/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Render;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.core.HttpError;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.Redirect;
import org.jboss.seam.util.DTDEntityResolver;
import org.jboss.seam.util.Reflections;
import org.jboss.seam.util.Resources;
import org.jboss.seam.util.Strings;
import org.jboss.seam.util.Transactions;
import org.xml.sax.EntityResolver;

@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Install(precedence=0)
@Name(value="org.jboss.seam.core.exceptions")
public class Exceptions {
    private static final Log log = LogFactory.getLog(Exceptions.class);
    private List<ExceptionHandler> exceptionHandlers = new ArrayList<ExceptionHandler>();

    public Object handle(Exception e) throws Exception {
        for (ExceptionHandler eh : this.exceptionHandlers) {
            if (!eh.isHandler(e)) continue;
            return eh.handle(e);
        }
        throw e;
    }

    @Create
    public void initialize() throws Exception {
        InputStream stream = Resources.getResourceAsStream("/WEB-INF/exceptions.xml");
        ExceptionHandler anyhandler = null;
        if (stream == null) {
            log.info((Object)"no exceptions.xml file found");
        } else {
            log.info((Object)"reading exceptions.xml");
            SAXReader saxReader = new SAXReader();
            saxReader.setEntityResolver((EntityResolver)new DTDEntityResolver());
            saxReader.setMergeAdjacentText(true);
            Document doc = saxReader.read(stream);
            List elements = doc.getRootElement().elements("exception");
            for (Element exception : elements) {
                String className = exception.attributeValue("class");
                if (className == null) {
                    anyhandler = this.createHandler(exception, Exception.class);
                    continue;
                }
                ExceptionHandler handler = this.createHandler(exception, Reflections.classForName(className));
                if (handler == null) continue;
                this.exceptionHandlers.add(handler);
            }
        }
        this.exceptionHandlers.add(new RenderHandler());
        this.exceptionHandlers.add(new RedirectHandler());
        this.exceptionHandlers.add(new ErrorHandler());
        if (Init.instance().isDebug()) {
            this.exceptionHandlers.add(new DebugPageHandler());
        }
        if (anyhandler != null) {
            this.exceptionHandlers.add(anyhandler);
        }
    }

    private ExceptionHandler createHandler(Element exception, final Class clazz) {
        final boolean endConversation = exception.elementIterator("end-conversation").hasNext();
        final boolean rollback = exception.elementIterator("rollback").hasNext();
        Element render = exception.element("render");
        if (render != null) {
            final String viewId = render.attributeValue("view-id");
            final String message = render.getTextTrim();
            return new RenderHandler(){

                protected String getMessage(Exception e) {
                    return message;
                }

                protected String getViewId(Exception e) {
                    return viewId;
                }

                public boolean isHandler(Exception e) {
                    return clazz.isInstance(e) && Lifecycle.getPhaseId() == PhaseId.INVOKE_APPLICATION;
                }

                protected boolean isEnd(Exception e) {
                    return endConversation;
                }

                protected boolean isRollback(Exception e) {
                    return rollback;
                }
            };
        }
        Element redirect = exception.element("redirect");
        if (redirect != null) {
            final String viewId = redirect.attributeValue("view-id");
            final String message = redirect.getTextTrim();
            return new RedirectHandler(){

                protected String getMessage(Exception e) {
                    return message;
                }

                protected String getViewId(Exception e) {
                    return viewId;
                }

                public boolean isHandler(Exception e) {
                    return clazz.isInstance(e) && Lifecycle.getPhaseId() != PhaseId.RENDER_RESPONSE;
                }

                protected boolean isEnd(Exception e) {
                    return endConversation;
                }

                protected boolean isRollback(Exception e) {
                    return rollback;
                }
            };
        }
        Element error = exception.element("http-error");
        if (error != null) {
            String errorCode = error.attributeValue("error-code");
            final int code = Strings.isEmpty(errorCode) ? 500 : Integer.parseInt(errorCode);
            final String message = error.getTextTrim();
            return new ErrorHandler(){

                protected String getMessage(Exception e) {
                    return message;
                }

                protected int getCode(Exception e) {
                    return code;
                }

                public boolean isHandler(Exception e) {
                    return clazz.isInstance(e);
                }

                protected boolean isEnd(Exception e) {
                    return endConversation;
                }

                protected boolean isRollback(Exception e) {
                    return rollback;
                }
            };
        }
        return null;
    }

    protected static String getDisplayMessage(Exception e, String message) {
        if (Strings.isEmpty(message) && e.getMessage() != null) {
            return e.getMessage();
        }
        return message;
    }

    protected static void addFacesMessage(Exception e, String message) {
        if (!Strings.isEmpty(message = Exceptions.getDisplayMessage(e, message))) {
            FacesMessages.instance().add(message, new Object[0]);
        }
    }

    protected static void error(int code, String message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sending error: " + code));
        }
        HttpError httpError = HttpError.instance();
        if (message == null) {
            httpError.send(code);
        } else {
            httpError.send(code, message);
        }
    }

    protected static void redirect(String viewId) {
        if (Strings.isEmpty(viewId)) {
            viewId = FacesContext.getCurrentInstance().getViewRoot().getViewId();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("redirecting to: " + viewId));
        }
        Redirect redirect = Redirect.instance();
        redirect.setViewId(viewId);
        redirect.execute();
    }

    protected static void render(String viewId) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!Strings.isEmpty(viewId)) {
            UIViewRoot viewRoot = facesContext.getApplication().getViewHandler().createView(facesContext, viewId);
            facesContext.setViewRoot(viewRoot);
        } else {
            viewId = facesContext.getViewRoot().getViewId();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("rendering: " + viewId));
        }
        facesContext.renderResponse();
    }

    private static Object rethrow(Exception e) throws Exception {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        facesContext.responseComplete();
        facesContext.getExternalContext().getRequestMap().put("org.jboss.seam.exceptionHandled", e);
        throw e;
    }

    public static Exceptions instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application context");
        }
        return (Exceptions)Component.getInstance(Exceptions.class, ScopeType.APPLICATION);
    }

    public static class DebugPageHandler
    implements ExceptionHandler {
        public Object handle(Exception e) throws Exception {
            log.error((Object)"redirecting to debug page", (Throwable)e);
            Context conversationContext = Contexts.getConversationContext();
            conversationContext.set("org.jboss.seam.debug.lastException", e);
            conversationContext.set("org.jboss.seam.debug.phaseId", Lifecycle.getPhaseId().toString());
            Redirect redirect = Redirect.instance();
            redirect.setViewId("/debug.xhtml");
            Manager manager = Manager.instance();
            manager.beforeRedirect();
            redirect.setParameter(manager.getConversationIdParameter(), manager.getCurrentConversationId());
            redirect.execute();
            conversationContext.flush();
            return Exceptions.rethrow(e);
        }

        public boolean isHandler(Exception e) {
            return Lifecycle.getPhaseId() != PhaseId.RENDER_RESPONSE && Lifecycle.getPhaseId() != null;
        }

        public String toString() {
            return "Debug";
        }
    }

    public static class ErrorHandler
    implements ExceptionHandler {
        public Object handle(Exception e) throws Exception {
            if (this.isEnd(e)) {
                Conversation.instance().end();
            }
            if (this.isRollback(e)) {
                Transactions.setTransactionRollbackOnly();
            }
            String message = this.getMessage(e);
            Exceptions.error(this.getCode(e), Interpolator.instance().interpolate(Exceptions.getDisplayMessage(e, message), new Object[0]));
            return Exceptions.rethrow(e);
        }

        public boolean isHandler(Exception e) {
            return e.getClass().isAnnotationPresent(org.jboss.seam.annotations.HttpError.class);
        }

        protected String getMessage(Exception e) {
            return e.getClass().getAnnotation(org.jboss.seam.annotations.HttpError.class).message();
        }

        protected int getCode(Exception e) {
            return e.getClass().getAnnotation(org.jboss.seam.annotations.HttpError.class).errorCode();
        }

        protected boolean isEnd(Exception e) {
            return e.getClass().getAnnotation(org.jboss.seam.annotations.HttpError.class).end();
        }

        protected boolean isRollback(Exception e) {
            return e.getClass().getAnnotation(org.jboss.seam.annotations.HttpError.class).rollback();
        }

        public String toString() {
            return "ErrorHandler";
        }
    }

    public static class RenderHandler
    implements ExceptionHandler {
        public Object handle(Exception e) throws Exception {
            Exceptions.addFacesMessage(e, this.getMessage(e));
            if (this.isEnd(e)) {
                Conversation.instance().end();
            }
            if (this.isRollback(e)) {
                Transactions.setTransactionRollbackOnly();
            }
            Exceptions.render(this.getViewId(e));
            return null;
        }

        public boolean isHandler(Exception e) {
            return e.getClass().isAnnotationPresent(Render.class) && Lifecycle.getPhaseId() == PhaseId.INVOKE_APPLICATION;
        }

        protected String getMessage(Exception e) {
            return e.getClass().getAnnotation(Render.class).message();
        }

        protected String getViewId(Exception e) {
            return e.getClass().getAnnotation(Render.class).viewId();
        }

        protected boolean isEnd(Exception e) {
            return e.getClass().getAnnotation(Render.class).end();
        }

        protected boolean isRollback(Exception e) {
            return e.getClass().getAnnotation(Render.class).rollback();
        }

        public String toString() {
            return "RenderHandler";
        }
    }

    public static class RedirectHandler
    implements ExceptionHandler {
        public Object handle(Exception e) throws Exception {
            Exceptions.addFacesMessage(e, this.getMessage(e));
            if (this.isEnd(e)) {
                Conversation.instance().end();
            }
            if (this.isRollback(e)) {
                Transactions.setTransactionRollbackOnly();
            }
            Exceptions.redirect(this.getViewId(e));
            return Exceptions.rethrow(e);
        }

        public boolean isHandler(Exception e) {
            return e.getClass().isAnnotationPresent(org.jboss.seam.annotations.Redirect.class) && Lifecycle.getPhaseId() != PhaseId.RENDER_RESPONSE && Lifecycle.getPhaseId() != null;
        }

        protected String getMessage(Exception e) {
            return e.getClass().getAnnotation(org.jboss.seam.annotations.Redirect.class).message();
        }

        protected String getViewId(Exception e) {
            return e.getClass().getAnnotation(org.jboss.seam.annotations.Redirect.class).viewId();
        }

        protected boolean isEnd(Exception e) {
            return e.getClass().getAnnotation(org.jboss.seam.annotations.Redirect.class).end();
        }

        protected boolean isRollback(Exception e) {
            return e.getClass().getAnnotation(org.jboss.seam.annotations.Redirect.class).rollback();
        }

        public String toString() {
            return "RedirectHandler";
        }
    }

    public static interface ExceptionHandler {
        public Object handle(Exception var1) throws Exception;

        public boolean isHandler(Exception var1);
    }
}

