/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.hibernate.validator.InvalidValue;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.CONVERSATION)
@Name(value="org.jboss.seam.core.facesMessages")
@Install(precedence=0)
@Intercept(value=InterceptionType.NEVER)
public class FacesMessages
implements Serializable {
    private transient List<Runnable> tasks;
    private List<FacesMessage> facesMessages = new ArrayList<FacesMessage>();
    private Map<String, List<FacesMessage>> keyedFacesMessages = new HashMap<String, List<FacesMessage>>();

    public void beforeRenderResponse() {
        for (FacesMessage facesMessage : this.facesMessages) {
            FacesContext.getCurrentInstance().addMessage(null, facesMessage);
        }
        for (Map.Entry entry : this.keyedFacesMessages.entrySet()) {
            for (FacesMessage msg : (List)entry.getValue()) {
                FacesContext.getCurrentInstance().addMessage((String)entry.getKey(), msg);
            }
        }
        this.clear();
    }

    public List<FacesMessage> getCurrentMessages() {
        ArrayList<FacesMessage> result = new ArrayList<FacesMessage>();
        Iterator iter = FacesContext.getCurrentInstance().getMessages();
        while (iter.hasNext()) {
            result.add((FacesMessage)iter.next());
        }
        return result;
    }

    public List<FacesMessage> getCurrentGlobalMessages() {
        ArrayList<FacesMessage> result = new ArrayList<FacesMessage>();
        Iterator iter = FacesContext.getCurrentInstance().getMessages(null);
        while (iter.hasNext()) {
            result.add((FacesMessage)iter.next());
        }
        return result;
    }

    private void runTasks() {
        if (this.tasks != null) {
            for (Runnable task : this.tasks) {
                task.run();
            }
            this.tasks.clear();
        }
    }

    public static void afterPhase() {
        FacesMessages instance;
        if (Contexts.isConversationContextActive() && (instance = (FacesMessages)Component.getInstance(FacesMessages.class, ScopeType.CONVERSATION, false)) != null) {
            instance.runTasks();
        }
    }

    public void clear() {
        this.facesMessages.clear();
        this.keyedFacesMessages.clear();
    }

    public void add(FacesMessage facesMessage) {
        this.facesMessages.add(facesMessage);
    }

    public void add(String id, FacesMessage facesMessage) {
        String clientId = this.getClientId(id);
        List<FacesMessage> list = this.keyedFacesMessages.get(clientId);
        if (list == null) {
            list = new ArrayList<FacesMessage>();
            this.keyedFacesMessages.put(clientId, list);
        }
        list.add(facesMessage);
    }

    public void add(String id, String messageTemplate, Object ... params) {
        this.add(id, FacesMessage.SEVERITY_INFO, messageTemplate, params);
    }

    public void add(final String id, final FacesMessage.Severity severity, final String messageTemplate, final Object ... params) {
        this.getTasks().add(new Runnable(){

            public void run() {
                FacesMessages.this.add(id, FacesMessages.createFacesMessage(severity, messageTemplate, params));
            }
        });
    }

    public static FacesMessages instance() {
        if (!Contexts.isConversationContextActive()) {
            throw new IllegalStateException("No active conversation context");
        }
        return (FacesMessages)Component.getInstance(FacesMessages.class, ScopeType.CONVERSATION);
    }

    public void add(String messageTemplate, Object ... params) {
        this.add(FacesMessage.SEVERITY_INFO, messageTemplate, params);
    }

    public void add(final FacesMessage.Severity severity, final String messageTemplate, final Object ... params) {
        this.getTasks().add(new Runnable(){

            public void run() {
                FacesMessages.this.add(FacesMessages.createFacesMessage(severity, messageTemplate, params));
            }
        });
    }

    public void addFromResourceBundle(String key, Object ... params) {
        this.addFromResourceBundle(FacesMessage.SEVERITY_INFO, key, params);
    }

    public void addFromResourceBundle(FacesMessage.Severity severity, String key, Object ... params) {
        this.addFromResourceBundle(severity, key, key, params);
    }

    public void addFromResourceBundle(String id, String key, Object ... params) {
        this.addFromResourceBundle(id, FacesMessage.SEVERITY_INFO, key, params);
    }

    public void addFromResourceBundle(String id, FacesMessage.Severity severity, String key, Object ... params) {
        this.addFromResourceBundle(id, severity, key, key, params);
    }

    public void addFromResourceBundle(FacesMessage.Severity severity, String key, String defaultMessageTemplate, Object ... params) {
        this.add(severity, this.interpolateBundleMessage(key, defaultMessageTemplate), params);
    }

    public void addFromResourceBundle(String id, FacesMessage.Severity severity, String key, String defaultMessageTemplate, Object ... params) {
        this.add(id, severity, this.interpolateBundleMessage(key, defaultMessageTemplate), params);
    }

    private String interpolateBundleMessage(String key, String defaultMessageTemplate) {
        String messageTemplate = defaultMessageTemplate;
        java.util.ResourceBundle resourceBundle = ResourceBundle.instance();
        if (resourceBundle != null && key != null) {
            try {
                String bundleMessage = resourceBundle.getString(key);
                if (bundleMessage != null) {
                    messageTemplate = bundleMessage;
                }
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
        }
        return messageTemplate;
    }

    public void add(InvalidValue iv) {
        this.add(iv.getPropertyName(), FacesMessage.SEVERITY_WARN, iv.getMessage(), new Object[0]);
    }

    public static FacesMessage createFacesMessage(FacesMessage.Severity severity, String messageTemplate, Object ... params) {
        return new FacesMessage(severity, Interpolator.instance().interpolate(messageTemplate, params), null);
    }

    private String getClientId(String id) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return FacesMessages.getClientId((UIComponent)facesContext.getViewRoot(), id, facesContext);
    }

    private static String getClientId(UIComponent component, String id, FacesContext facesContext) {
        String componentId = component.getId();
        if (componentId != null && componentId.equals(id)) {
            return component.getClientId(facesContext);
        }
        Iterator iter = component.getFacetsAndChildren();
        while (iter.hasNext()) {
            UIComponent child = (UIComponent)iter.next();
            String clientId = FacesMessages.getClientId(child, id, facesContext);
            if (clientId == null) continue;
            return clientId;
        }
        return null;
    }

    private List<Runnable> getTasks() {
        if (this.tasks == null) {
            this.tasks = new ArrayList<Runnable>();
        }
        return this.tasks;
    }
}

