/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.Namespace;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.util.Transactions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Name(value="org.jboss.seam.core.init")
@Install(value=false, precedence=0)
public class Init {
    private Namespace rootNamespace = new Namespace(null);
    private boolean isClientSideConversations = false;
    private boolean jbpmInstalled;
    private String jndiPattern;
    private boolean debug;
    private boolean myFacesLifecycleBug;
    private String userTransactionName;
    private Map<String, List<ObserverMethod>> observers = new HashMap<String, List<ObserverMethod>>();
    private Map<String, FactoryMethod> factories = new HashMap<String, FactoryMethod>();
    private Map<String, FactoryBinding> factoryMethodBindings = new HashMap<String, FactoryBinding>();
    private Map<String, FactoryBinding> factoryValueBindings = new HashMap<String, FactoryBinding>();
    private Set<String> autocreateVariables = new HashSet<String>();

    @Create
    public void create() {
        if (this.userTransactionName != null) {
            Transactions.setUserTransactionName(this.userTransactionName);
        }
    }

    public static Init instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application scope");
        }
        Init init = (Init)Contexts.getApplicationContext().get(Init.class);
        return init;
    }

    public boolean isClientSideConversations() {
        return this.isClientSideConversations;
    }

    public void setClientSideConversations(boolean isClientSideConversations) {
        this.isClientSideConversations = isClientSideConversations;
    }

    public FactoryMethod getFactory(String variable) {
        return this.factories.get(variable);
    }

    public FactoryBinding getFactoryMethodBinding(String variable) {
        return this.factoryMethodBindings.get(variable);
    }

    public FactoryBinding getFactoryValueBinding(String variable) {
        return this.factoryValueBindings.get(variable);
    }

    public void addFactoryMethod(String variable, Method method, Component component) {
        this.factories.put(variable, new FactoryMethod(method, component));
    }

    public void addFactoryMethodBinding(String variable, String methodBindingExpression, ScopeType scope) {
        this.factoryMethodBindings.put(variable, new FactoryBinding(methodBindingExpression, scope));
    }

    public void addFactoryValueBinding(String variable, String valueBindingExpression, ScopeType scope) {
        this.factoryValueBindings.put(variable, new FactoryBinding(valueBindingExpression, scope));
    }

    public List<ObserverMethod> getObservers(String eventType) {
        return this.observers.get(eventType);
    }

    public void addObserverMethod(String eventType, Method method, Component component) {
        List<ObserverMethod> observerList = this.observers.get(eventType);
        if (observerList == null) {
            observerList = new ArrayList<ObserverMethod>();
            this.observers.put(eventType, observerList);
        }
        observerList.add(new ObserverMethod(method, component));
    }

    public boolean isJbpmInstalled() {
        return this.jbpmInstalled;
    }

    public String getJndiPattern() {
        return this.jndiPattern;
    }

    public void setJndiPattern(String jndiPattern) {
        this.jndiPattern = jndiPattern;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isMyFacesLifecycleBug() {
        return this.myFacesLifecycleBug;
    }

    public void setMyFacesLifecycleBug(boolean myFacesLifecycleBugExists) {
        this.myFacesLifecycleBug = myFacesLifecycleBugExists;
    }

    public void setJbpmInstalled(boolean jbpmInstalled) {
        this.jbpmInstalled = jbpmInstalled;
    }

    protected String getUserTransactionName() {
        return this.userTransactionName;
    }

    protected void setUserTransactionName(String userTransactionName) {
        this.userTransactionName = userTransactionName;
    }

    public boolean isAutocreateVariable(String name) {
        return this.autocreateVariables.contains(name);
    }

    public void addAutocreateVariable(String name) {
        this.autocreateVariables.add(name);
    }

    public Namespace getRootNamespace() {
        return this.rootNamespace;
    }

    public static class ObserverMethod {
        public Method method;
        public Component component;

        ObserverMethod(Method method, Component component) {
            this.method = method;
            this.component = component;
        }

        public String toString() {
            return "ObserverMethod(" + this.method + ')';
        }
    }

    public static class FactoryBinding {
        private String expression;
        private ScopeType scope;

        FactoryBinding(String expression, ScopeType scope) {
            this.expression = expression;
            this.scope = scope;
        }

        public Expressions.MethodBinding getMethodBinding() {
            return Expressions.instance().createMethodBinding(this.expression);
        }

        public Expressions.ValueBinding getValueBinding() {
            return Expressions.instance().createValueBinding(this.expression);
        }

        public ScopeType getScope() {
            return this.scope;
        }

        public String toString() {
            return "FactoryBinding(" + this.expression + ')';
        }
    }

    public static class FactoryMethod {
        private Method method;
        private Component component;
        private ScopeType scope;

        FactoryMethod(Method method, Component component) {
            this.method = method;
            this.component = component;
            this.scope = method.getAnnotation(Factory.class).scope();
        }

        public ScopeType getScope() {
            return this.scope;
        }

        public Component getComponent() {
            return this.component;
        }

        public Method getMethod() {
            return this.method;
        }

        public String toString() {
            return "FactoryMethod(" + this.method + ')';
        }
    }
}

