/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.AbstractMutable;
import org.jboss.seam.core.Messages;
import org.jboss.seam.core.ResourceBundle;
import org.jboss.seam.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.SESSION)
@Name(value="org.jboss.seam.core.localeSelector")
@Intercept(value=InterceptionType.NEVER)
@Install(precedence=0)
public class LocaleSelector
extends AbstractMutable
implements Serializable {
    private String language;
    private String country;
    private String variant;
    private boolean cookieEnabled;
    private int cookieMaxAge = 31536000;

    @Create
    public void initLocale() {
        Cookie cookie;
        if (this.cookieEnabled && (cookie = (Cookie)FacesContext.getCurrentInstance().getExternalContext().getRequestCookieMap().get("org.jboss.seam.core.Locale")) != null) {
            this.setLocaleString(cookie.getValue());
        }
    }

    public void select() {
        FacesContext.getCurrentInstance().getViewRoot().setLocale(this.getLocale());
        Contexts.removeFromAllContexts(Seam.getComponentName(ResourceBundle.class));
        Contexts.removeFromAllContexts(Seam.getComponentName(Messages.class));
        if (this.cookieEnabled) {
            HttpServletResponse response = (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
            Cookie cookie = new Cookie("org.jboss.seam.core.Locale", this.getLocaleString());
            cookie.setMaxAge(this.cookieMaxAge);
            response.addCookie(cookie);
        }
    }

    public void selectLanguage(String language) {
        this.setLanguage(language);
        this.select();
    }

    public Locale calculateLocale(Locale jsfLocale) {
        if (!Strings.isEmpty(this.variant)) {
            return new Locale(this.language, this.country, this.variant);
        }
        if (!Strings.isEmpty(this.country)) {
            return new Locale(this.language, this.country);
        }
        if (!Strings.isEmpty(this.language)) {
            return new Locale(this.language);
        }
        return jsfLocale;
    }

    public void setLocale(Locale locale) {
        this.language = Strings.nullIfEmpty(locale.getLanguage());
        this.country = Strings.nullIfEmpty(locale.getCountry());
        this.variant = Strings.nullIfEmpty(locale.getVariant());
    }

    public String getLocaleString() {
        return this.getLocale().toString();
    }

    public void setLocaleString(String localeString) {
        StringTokenizer tokens = new StringTokenizer(localeString, "-_");
        this.language = tokens.hasMoreTokens() ? tokens.nextToken() : null;
        this.country = tokens.hasMoreTokens() ? tokens.nextToken() : null;
        this.variant = tokens.hasMoreTokens() ? tokens.nextToken() : null;
    }

    public List<SelectItem> getSupportedLocales() {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        Iterator locales = FacesContext.getCurrentInstance().getApplication().getSupportedLocales();
        while (locales.hasNext()) {
            Locale locale = (Locale)locales.next();
            if (Strings.isEmpty(locale.getLanguage())) continue;
            selectItems.add(new SelectItem((Object)locale.toString(), locale.getDisplayName(locale)));
        }
        return selectItems;
    }

    public Locale getLocale() {
        Locale requestLocale;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            return facesContext.getApplication().getViewHandler().calculateLocale(facesContext);
        }
        ServletRequest request = Lifecycle.getServletRequest();
        if (request != null && (requestLocale = ((HttpServletRequest)request).getLocale()) != null) {
            return this.calculateLocale(requestLocale);
        }
        return this.calculateLocale(Locale.getDefault());
    }

    public static LocaleSelector instance() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No active session context");
        }
        return (LocaleSelector)Component.getInstance(LocaleSelector.class, ScopeType.SESSION);
    }

    public String getCountry() {
        if (this.country == null) {
            return this.getLocale().getCountry();
        }
        return this.country;
    }

    public void setCountry(String country) {
        this.setDirty(this.country, country);
        this.country = country;
    }

    public String getLanguage() {
        if (this.language == null) {
            return this.getLocale().getLanguage();
        }
        return this.language;
    }

    public void setLanguage(String language) {
        this.setDirty(this.language, language);
        this.language = language;
    }

    public String getVariant() {
        if (this.variant == null) {
            return this.getLocale().getVariant();
        }
        return this.variant;
    }

    public void setVariant(String variant) {
        this.setDirty(this.variant, variant);
        this.variant = variant;
    }

    public boolean isCookieEnabled() {
        return this.cookieEnabled;
    }

    public void setCookieEnabled(boolean cookieEnabled) {
        this.setDirty(this.cookieEnabled, cookieEnabled);
        this.cookieEnabled = cookieEnabled;
    }

    protected int getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    protected void setCookieMaxAge(int cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }
}

