/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.FlushModeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Filter;
import org.jboss.seam.core.Mutable;
import org.jboss.seam.core.PersistenceContextManager;
import org.jboss.seam.core.PersistenceContexts;
import org.jboss.seam.persistence.PersistenceProvider;
import org.jboss.seam.util.Naming;
import org.jboss.seam.util.Transactions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.CONVERSATION)
@Intercept(value=InterceptionType.NEVER)
@Install(value=false)
public class ManagedPersistenceContext
implements Serializable,
HttpSessionActivationListener,
Mutable,
PersistenceContextManager {
    private static final Log log = LogFactory.getLog(ManagedPersistenceContext.class);
    private EntityManager entityManager;
    private String persistenceUnitJndiName;
    private String componentName;
    private Expressions.ValueBinding<EntityManagerFactory> entityManagerFactory;
    private List<Filter> filters = new ArrayList<Filter>(0);

    @Override
    public boolean clearDirty() {
        return true;
    }

    @Create
    public void create(Component component) {
        this.componentName = component.getName();
        if (this.persistenceUnitJndiName == null) {
            this.persistenceUnitJndiName = "java:/" + this.componentName;
        }
        this.createEntityManager();
        PersistenceContexts.instance().touch(this.componentName);
        if (log.isDebugEnabled()) {
            if (this.entityManagerFactory == null) {
                log.debug((Object)("created seam managed persistence context for persistence unit: " + this.persistenceUnitJndiName));
            } else {
                log.debug((Object)"created seam managed persistence context from EntityManagerFactory");
            }
        }
    }

    private void createEntityManager() {
        this.entityManager = this.getEntityManagerFactoryFromJndiOrValueBinding().createEntityManager();
        this.setFlushMode(PersistenceContexts.instance().getFlushMode());
        for (Filter f : this.filters) {
            PersistenceProvider.instance().enableFilter(f, this.entityManager);
        }
    }

    @Unwrap
    public EntityManager getEntityManager() throws NamingException, SystemException {
        if (!Lifecycle.isDestroying() && Transactions.isTransactionActive()) {
            this.entityManager.joinTransaction();
        }
        return this.entityManager;
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        if (!PersistenceProvider.instance().isDirty(this.entityManager)) {
            this.entityManager.close();
            this.entityManager = null;
        }
    }

    public void sessionDidActivate(HttpSessionEvent event) {
        if (this.entityManager == null) {
            this.createEntityManager();
        }
    }

    @Destroy
    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("destroying seam managed persistence context for persistence unit: " + this.persistenceUnitJndiName));
        }
        this.entityManager.close();
    }

    public EntityManagerFactory getEntityManagerFactoryFromJndiOrValueBinding() {
        if (this.entityManagerFactory == null) {
            try {
                return (EntityManagerFactory)Naming.getInitialContext().lookup(this.persistenceUnitJndiName);
            }
            catch (NamingException ne) {
                throw new IllegalArgumentException("EntityManagerFactory not found in JNDI", ne);
            }
        }
        return this.entityManagerFactory.getValue();
    }

    public Expressions.ValueBinding<EntityManagerFactory> getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(Expressions.ValueBinding<EntityManagerFactory> entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public String getPersistenceUnitJndiName() {
        return this.persistenceUnitJndiName;
    }

    public void setPersistenceUnitJndiName(String persistenceUnitName) {
        this.persistenceUnitJndiName = persistenceUnitName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    protected List<Filter> getFilters() {
        return this.filters;
    }

    protected void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    @Override
    public void setFlushMode(FlushModeType flushMode) {
        switch (flushMode) {
            case AUTO: {
                this.entityManager.setFlushMode(javax.persistence.FlushModeType.AUTO);
                break;
            }
            case COMMIT: {
                this.entityManager.setFlushMode(javax.persistence.FlushModeType.COMMIT);
                break;
            }
            case MANUAL: {
                PersistenceProvider.instance().setFlushModeManual(this.entityManager);
            }
        }
    }

    public String toString() {
        return "ManagedPersistenceContext(" + this.persistenceUnitJndiName + ")";
    }
}

