/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.ContextAdaptor;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.contexts.ServerConversationContext;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.core.ConversationEntries;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.core.FacesPage;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.Page;
import org.jboss.seam.core.Pageflow;
import org.jboss.seam.core.Pages;
import org.jboss.seam.util.Id;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.EVENT)
@Name(value="org.jboss.seam.core.manager")
@Install(precedence=0)
@Intercept(value=InterceptionType.NEVER)
public class Manager {
    private static final Log log = LogFactory.getLog(Manager.class);
    private String currentConversationId;
    private List<String> currentConversationIdStack;
    private boolean isLongRunningConversation;
    private boolean updateModelValuesCalled;
    private boolean controllingRedirect;
    private boolean destroyBeforeRedirect;
    private int conversationTimeout = 600000;
    private int concurrentRequestTimeout = 1000;
    private String conversationIdParameter = "conversationId";
    private String parentConversationIdParameter = "parentConversationId";
    private String conversationIsLongRunningParameter = "conversationIsLongRunning";
    private ConversationEntry currentConversationEntry;

    public String getCurrentConversationId() {
        return this.currentConversationId;
    }

    public void setCurrentConversationId(String id) {
        this.currentConversationId = id;
        this.currentConversationEntry = null;
    }

    public void updateCurrentConversationId(String id) {
        int i;
        String[] names = Contexts.getConversationContext().getNames();
        Object[] values = new Object[names.length];
        for (i = 0; i < names.length; ++i) {
            values[i] = Contexts.getConversationContext().get(names[i]);
            Contexts.getConversationContext().remove(names[i]);
        }
        Contexts.getConversationContext().flush();
        ConversationEntries.instance().updateConversationId(this.getCurrentConversationId(), id);
        this.currentConversationIdStack.set(0, id);
        this.setCurrentConversationId(id);
        for (i = 0; i < names.length; ++i) {
            Contexts.getConversationContext().set(names[i], values[i]);
        }
    }

    private static void touchConversationStack(List<String> stack) {
        if (stack != null) {
            ListIterator<String> iter = stack.listIterator(stack.size());
            while (iter.hasPrevious()) {
                String conversationId = iter.previous();
                ConversationEntry conversationEntry = ConversationEntries.instance().getConversationEntry(conversationId);
                if (conversationEntry == null) continue;
                conversationEntry.touch();
            }
        }
    }

    private static void endNestedConversations(String id) {
        for (ConversationEntry ce : ConversationEntries.instance().getConversationEntries()) {
            if (!ce.getConversationIdStack().contains(id)) continue;
            ce.end();
        }
    }

    public Object getCurrentConversationInitiator() {
        ConversationEntry ce = this.getCurrentConversationEntry();
        if (ce != null) {
            return ce.getInitiatorComponentName();
        }
        return null;
    }

    public List<String> getCurrentConversationIdStack() {
        return this.currentConversationIdStack;
    }

    private void setCurrentConversationIdStack(List<String> stack) {
        this.currentConversationIdStack = stack;
    }

    private List<String> createCurrentConversationIdStack(String id) {
        this.currentConversationIdStack = new ArrayList<String>();
        this.currentConversationIdStack.add(id);
        return this.currentConversationIdStack;
    }

    public String getCurrentConversationDescription() {
        ConversationEntry ce = this.getCurrentConversationEntry();
        if (ce == null) {
            return null;
        }
        return ce.getDescription();
    }

    public Integer getCurrentConversationTimeout() {
        ConversationEntry ce = this.getCurrentConversationEntry();
        if (ce == null) {
            return null;
        }
        return ce.getTimeout();
    }

    public String getCurrentConversationViewId() {
        ConversationEntry ce = this.getCurrentConversationEntry();
        if (ce == null) {
            return null;
        }
        return ce.getViewId();
    }

    public String getParentConversationViewId() {
        ConversationEntry conversationEntry = ConversationEntries.instance().getConversationEntry(this.getParentConversationId());
        return conversationEntry == null ? null : conversationEntry.getViewId();
    }

    public String getParentConversationId() {
        return this.currentConversationIdStack == null || this.currentConversationIdStack.size() < 2 ? null : this.currentConversationIdStack.get(1);
    }

    public String getRootConversationId() {
        return this.currentConversationIdStack == null || this.currentConversationIdStack.size() < 1 ? null : this.currentConversationIdStack.get(this.currentConversationIdStack.size() - 1);
    }

    public boolean isLongRunningConversation() {
        return this.isLongRunningConversation;
    }

    public boolean isLongRunningOrNestedConversation() {
        return this.isLongRunningConversation() || this.isNestedConversation();
    }

    public boolean isReallyLongRunningConversation() {
        return this.isLongRunningConversation() && !this.getCurrentConversationEntry().isRemoveAfterRedirect() && !Seam.isSessionInvalid();
    }

    public boolean isNestedConversation() {
        return this.currentConversationIdStack != null && this.currentConversationIdStack.size() > 1;
    }

    public void setLongRunningConversation(boolean isLongRunningConversation) {
        this.isLongRunningConversation = isLongRunningConversation;
    }

    public static Manager instance() {
        if (!Contexts.isEventContextActive()) {
            throw new IllegalStateException("No active event context");
        }
        Manager instance = (Manager)Component.getInstance(Manager.class, ScopeType.EVENT);
        if (instance == null) {
            throw new IllegalStateException("No Manager could be created, make sure the Component exists in application scope");
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void conversationTimeout(ContextAdaptor session) {
        long currentTime = System.currentTimeMillis();
        ArrayList<ConversationEntry> entries = new ArrayList<ConversationEntry>(ConversationEntries.instance().getConversationEntries());
        for (ConversationEntry conversationEntry : entries) {
            boolean locked = conversationEntry.lockNoWait();
            try {
                long delta = currentTime - conversationEntry.getLastRequestTime();
                if (delta <= (long)conversationEntry.getTimeout()) continue;
                if (locked) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("conversation timeout for conversation: " + conversationEntry.getId()));
                    }
                } else {
                    log.info((Object)("destroying conversation with garbage lock: " + conversationEntry.getId()));
                }
                this.destroyConversation(conversationEntry.getId(), session);
            }
            finally {
                if (!locked) continue;
                conversationEntry.unlock();
            }
        }
    }

    private void destroyConversation(String conversationId, ContextAdaptor session) {
        ServerConversationContext conversationContext = new ServerConversationContext(session, conversationId);
        Contexts.destroy(conversationContext);
        conversationContext.clear();
        conversationContext.flush();
        ConversationEntries.instance().removeConversationEntry(conversationId);
    }

    public void endRequest(ContextAdaptor session) {
        if (this.isLongRunningConversation()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Storing conversation state: " + this.getCurrentConversationId()));
            }
            Manager.touchConversationStack(this.getCurrentConversationIdStack());
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Discarding conversation state: " + this.getCurrentConversationId()));
            }
            this.removeCurrentConversationAndDestroyNestedContexts(session);
        }
        if (!Init.instance().isClientSideConversations()) {
            Manager.instance().conversationTimeout(session);
        }
    }

    public void unlockConversation() {
        ConversationEntry ce = this.getCurrentConversationEntry();
        if (ce != null) {
            if (ce.isLockedByCurrentThread()) {
                ce.unlock();
            }
        } else if (this.isNestedConversation()) {
            ConversationEntries.instance().getConversationEntry(this.getParentConversationId()).unlock();
        }
    }

    private void removeCurrentConversationAndDestroyNestedContexts(ContextAdaptor session) {
        ConversationEntries.instance().removeConversationEntry(this.getCurrentConversationId());
        this.destroyNestedConversationContexts(session, this.getCurrentConversationId());
    }

    private void destroyNestedConversationContexts(ContextAdaptor session, String conversationId) {
        ArrayList<ConversationEntry> entries = new ArrayList<ConversationEntry>(ConversationEntries.instance().getConversationEntries());
        for (ConversationEntry ce : entries) {
            if (!ce.getConversationIdStack().contains(conversationId)) continue;
            String entryConversationId = ce.getId();
            log.debug((Object)("destroying nested conversation: " + entryConversationId));
            this.destroyConversation(entryConversationId, session);
        }
    }

    private String getPropagationFromRequestParameter(Map parameters) {
        Object type = parameters.get("conversationPropagation");
        if (type == null) {
            return null;
        }
        if (type instanceof String) {
            return (String)type;
        }
        return ((String[])type)[0];
    }

    public boolean restoreConversation(Map parameters) {
        String propagation;
        String storedConversationId = this.getRequestParameterValue(parameters, this.conversationIdParameter);
        String storedParentConversationId = this.getRequestParameterValue(parameters, this.parentConversationIdParameter);
        Boolean isLongRunningConversation = "true".equals(this.getRequestParameterValue(parameters, this.conversationIsLongRunningParameter));
        if (this.isMissing(storedConversationId)) {
            if (Contexts.isPageContextActive()) {
                FacesPage page = FacesPage.instance();
                storedConversationId = page.getConversationId();
                storedParentConversationId = null;
                isLongRunningConversation = page.isConversationLongRunning();
            }
        } else {
            log.debug((Object)("Found conversation id in request parameter: " + storedConversationId));
        }
        if ("new".equals(storedConversationId)) {
            storedConversationId = null;
            storedParentConversationId = null;
            isLongRunningConversation = false;
        }
        if ("none".equals(propagation = this.getPropagationFromRequestParameter(parameters))) {
            storedConversationId = null;
            storedParentConversationId = null;
            isLongRunningConversation = false;
        }
        return this.restoreConversation(storedConversationId, storedParentConversationId, isLongRunningConversation) || "end".equals(propagation);
    }

    public void handleConversationPropagation(Map parameters) {
        String propagation = this.getPropagationFromRequestParameter(parameters);
        if (propagation != null && propagation.startsWith("begin")) {
            if (this.isLongRunningConversation) {
                throw new IllegalStateException("long-running conversation already active");
            }
            this.beginConversation(null);
            if (propagation.length() > 6) {
                Pageflow.instance().begin(propagation.substring(6));
            }
        } else if (propagation != null && propagation.startsWith("join")) {
            if (!this.isLongRunningConversation) {
                this.beginConversation(null);
                if (propagation.length() > 5) {
                    Pageflow.instance().begin(propagation.substring(5));
                }
            }
        } else if (propagation != null && propagation.startsWith("nest")) {
            this.beginNestedConversation(null);
            if (propagation.length() > 5) {
                Pageflow.instance().begin(propagation.substring(5));
            }
        } else if ("end".equals(propagation)) {
            this.endConversation(false);
        }
    }

    public boolean restoreConversation(String conversationId) {
        return this.restoreConversation(conversationId, null, false);
    }

    private boolean restoreConversation(String conversationId, String parentConversationId, boolean isLongRunningConversation) {
        ConversationEntries entries;
        ConversationEntry ce = null;
        if (conversationId != null && (ce = (entries = ConversationEntries.instance()).getConversationEntry(conversationId)) == null) {
            ce = entries.getConversationEntry(parentConversationId);
        }
        return this.restoreAndLockConversation(ce, isLongRunningConversation);
    }

    private boolean restoreAndLockConversation(ConversationEntry ce, boolean isLongRunningConversation) {
        if (ce != null && ce.lock()) {
            boolean removeAfterRedirect;
            Manager.touchConversationStack(ce.getConversationIdStack());
            log.debug((Object)("Restoring conversation with id: " + ce.getId()));
            this.setLongRunningConversation(true);
            this.setCurrentConversationId(ce.getId());
            this.setCurrentConversationIdStack(ce.getConversationIdStack());
            boolean bl = removeAfterRedirect = ce.isRemoveAfterRedirect() && (!Init.instance().isDebug() || !"/debug.xhtml".equals(FacesContext.getCurrentInstance().getViewRoot().getViewId()));
            if (removeAfterRedirect) {
                this.setLongRunningConversation(false);
                ce.setRemoveAfterRedirect(false);
            }
            return true;
        }
        log.debug((Object)"No stored conversation, or concurrent call to the stored conversation");
        this.initializeTemporaryConversation();
        return !isLongRunningConversation;
    }

    private String getRequestParameterValue(Map parameters, String parameterName) {
        Object object = parameters.get(parameterName);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        String[] values = (String[])object;
        if (values.length != 1) {
            throw new IllegalArgumentException("expected exactly one value for conversationId request parameter");
        }
        return values[0];
    }

    private boolean isMissing(String storedConversationId) {
        return storedConversationId == null || "".equals(storedConversationId);
    }

    public void initializeTemporaryConversation() {
        String id = Id.nextId();
        this.setCurrentConversationId(id);
        this.createCurrentConversationIdStack(id);
        this.setLongRunningConversation(false);
    }

    private ConversationEntry createConversationEntry() {
        ConversationEntry entry = ConversationEntries.instance().createConversationEntry(this.getCurrentConversationId(), this.getCurrentConversationIdStack());
        if (!entry.isNested()) {
            entry.lock();
        }
        return entry;
    }

    public void beginConversation(String initiator) {
        log.debug((Object)"Beginning long-running conversation");
        this.setLongRunningConversation(true);
        this.createConversationEntry().setInitiatorComponentName(initiator);
        Conversation.instance();
        this.storeConversationToViewRootIfNecessary();
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.beginConversation", new Object[0]);
        }
    }

    public void beginNestedConversation(String ownerName) {
        log.debug((Object)"Beginning nested conversation");
        List<String> oldStack = this.getCurrentConversationIdStack();
        if (oldStack == null) {
            throw new IllegalStateException("No long-running conversation active");
        }
        String id = Id.nextId();
        this.setCurrentConversationId(id);
        this.createCurrentConversationIdStack(id).addAll(oldStack);
        ConversationEntry conversationEntry = this.createConversationEntry();
        conversationEntry.setInitiatorComponentName(ownerName);
        this.storeConversationToViewRootIfNecessary();
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.beginConversation", new Object[0]);
        }
    }

    public void endConversation(boolean beforeRedirect) {
        log.debug((Object)"Ending long-running conversation");
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.endConversation", new Object[0]);
        }
        this.setLongRunningConversation(false);
        this.destroyBeforeRedirect = beforeRedirect;
        Manager.endNestedConversations(this.getCurrentConversationId());
        this.storeConversationToViewRootIfNecessary();
    }

    private void storeConversationToViewRootIfNecessary() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && Lifecycle.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            FacesPage.instance().storeConversation();
        }
    }

    public ConversationEntry getCurrentConversationEntry() {
        if (this.currentConversationEntry == null) {
            this.currentConversationEntry = ConversationEntries.instance().getConversationEntry(this.getCurrentConversationId());
        }
        return this.currentConversationEntry;
    }

    public void leaveConversation() {
        this.initializeTemporaryConversation();
    }

    public boolean switchConversation(String id) {
        ConversationEntry ce = ConversationEntries.instance().getConversationEntry(id);
        if (ce != null) {
            if (ce.lock()) {
                this.unlockConversation();
                this.setCurrentConversationId(id);
                this.setCurrentConversationIdStack(ce.getConversationIdStack());
                this.setLongRunningConversation(true);
                return true;
            }
            return false;
        }
        return false;
    }

    public int getConversationTimeout() {
        return this.conversationTimeout;
    }

    public void setConversationTimeout(int conversationTimeout) {
        this.conversationTimeout = conversationTimeout;
    }

    public void beforeRedirect() {
        if (!this.destroyBeforeRedirect) {
            ConversationEntry ce = this.getCurrentConversationEntry();
            if (ce == null) {
                ce = this.createConversationEntry();
            }
            ce.setRemoveAfterRedirect(!this.isLongRunningConversation());
            this.setLongRunningConversation(true);
        }
    }

    public String encodeConversationId(String url) {
        if (Seam.isSessionInvalid()) {
            return url;
        }
        if (this.destroyBeforeRedirect) {
            if (this.isNestedConversation()) {
                return new StringBuilder(url.length() + this.conversationIdParameter.length() + 5).append(url).append(url.contains("?") ? (char)'&' : '?').append(this.conversationIdParameter).append('=').append(this.getParentConversationId()).append('&').append(this.conversationIsLongRunningParameter).append("=true").toString();
            }
            return url;
        }
        StringBuilder builder = new StringBuilder(url.length() + this.conversationIdParameter.length() + 5).append(url).append(url.contains("?") ? (char)'&' : '?').append(this.conversationIdParameter).append('=').append(this.getCurrentConversationId());
        if (this.isNestedConversation() && !this.isReallyLongRunningConversation()) {
            builder.append('&').append(this.parentConversationIdParameter).append('=').append(this.getParentConversationId());
        }
        if (this.isReallyLongRunningConversation()) {
            builder.append('&').append(this.conversationIsLongRunningParameter).append("=true");
        }
        return builder.toString();
    }

    public void redirect(String viewId) {
        this.redirect(viewId, null, true);
    }

    public void interpolateAndRedirect(String url) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        int loc = url.indexOf(63);
        if (loc > 0) {
            StringTokenizer tokens = new StringTokenizer(url.substring(loc), "?=&");
            while (tokens.hasMoreTokens()) {
                String name = tokens.nextToken();
                String value = Interpolator.instance().interpolate(tokens.nextToken(), new Object[0]);
                parameters.put(name, value);
            }
            url = url.substring(0, loc);
        }
        this.redirect(url, parameters, true);
    }

    public String encodeParameters(String url, Map<String, Object> parameters) {
        if (parameters.isEmpty()) {
            return url;
        }
        StringBuilder builder = new StringBuilder(url);
        for (Map.Entry<String, Object> param : parameters.entrySet()) {
            Object parameterValue = param.getValue();
            String parameterName = param.getKey();
            if (parameterValue instanceof Iterable) {
                for (Object value : (Iterable)parameterValue) {
                    builder.append('&').append(parameterName).append('=').append(value);
                }
                continue;
            }
            builder.append('&').append(parameterName).append('=').append(parameterValue);
        }
        if (url.indexOf(63) < 0) {
            builder.setCharAt(url.length(), '?');
        }
        return builder.toString();
    }

    public void redirect(String viewId, Map<String, Object> parameters, boolean includeConversationId) {
        if (Lifecycle.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            throw new IllegalStateException("attempted to redirect during RENDER_RESPONSE phase");
        }
        FacesContext context = FacesContext.getCurrentInstance();
        String url = context.getApplication().getViewHandler().getActionURL(context, viewId);
        if (parameters != null) {
            url = this.encodeParameters(url, parameters);
        }
        if (includeConversationId) {
            url = this.encodeConversationId(url);
            this.beforeRedirect();
        }
        ExternalContext externalContext = context.getExternalContext();
        this.controllingRedirect = true;
        try {
            externalContext.redirect(externalContext.encodeActionURL(url));
        }
        catch (IOException ioe) {
            throw new RuntimeException("could not redirect to: " + url, ioe);
        }
        finally {
            this.controllingRedirect = false;
        }
        context.responseComplete();
    }

    public String appendConversationIdFromRedirectFilter(String url) {
        boolean appendConversationId;
        boolean bl = appendConversationId = !this.controllingRedirect && !url.contains("?" + this.getConversationIdParameter() + "=");
        if (appendConversationId) {
            url = this.encodeConversationId(url);
            this.beforeRedirect();
        }
        return url;
    }

    public void prepareBackswitch(FacesContext facesContext) {
        org.jboss.seam.pageflow.Page pageflowPage;
        Conversation conversation = Conversation.instance();
        org.jboss.seam.pageflow.Page page = pageflowPage = this.isLongRunningConversation() && Init.instance().isJbpmInstalled() && Pageflow.instance().isInProcess() ? Pageflow.instance().getPage() : null;
        if (pageflowPage == null) {
            String viewId = facesContext.getViewRoot().getViewId();
            Pages pages = Pages.instance();
            if (pages != null) {
                Page pageEntry = pages.getPage(viewId);
                if (pageEntry.isSwitchEnabled()) {
                    conversation.setViewId(viewId);
                }
                if (pageEntry.hasDescription()) {
                    conversation.setDescription(pageEntry.renderDescription());
                }
                conversation.setTimeout(Pages.instance().getTimeout(viewId));
            }
        } else {
            if (pageflowPage.isSwitchEnabled()) {
                conversation.setViewId(pageflowPage.getViewId());
            }
            if (pageflowPage.hasDescription()) {
                conversation.setDescription(pageflowPage.getDescription());
            }
            conversation.setTimeout(pageflowPage.getTimeout());
        }
        if (this.isLongRunningConversation()) {
            conversation.flush();
        }
    }

    public String getConversationIdParameter() {
        return this.conversationIdParameter;
    }

    public void setConversationIdParameter(String conversationIdParameter) {
        this.conversationIdParameter = conversationIdParameter;
    }

    public String getConversationIsLongRunningParameter() {
        return this.conversationIsLongRunningParameter;
    }

    public void setConversationIsLongRunningParameter(String conversationIdLongRunning) {
        this.conversationIsLongRunningParameter = conversationIdLongRunning;
    }

    public void redirectToNoConversationView() {
        this.noConversation();
        FacesPage facesPage = FacesPage.instance();
        String pageflowName = facesPage.getPageflowName();
        String pageflowNodeName = facesPage.getPageflowNodeName();
        String noConversationViewId = null;
        if (pageflowName == null || pageflowNodeName == null) {
            String viewId = FacesContext.getCurrentInstance().getViewRoot().getViewId();
            Pages pages = Pages.instance();
            if (pages != null) {
                noConversationViewId = pages.getNoConversationViewId(viewId);
            }
        } else {
            noConversationViewId = Pageflow.instance().getNoConversationViewId(pageflowName, pageflowNodeName);
        }
        if (noConversationViewId != null) {
            this.redirect(noConversationViewId);
        }
    }

    protected void noConversation() {
        FacesMessages.instance().addFromResourceBundle(FacesMessage.SEVERITY_WARN, "org.jboss.seam.NoConversation", "The conversation ended, timed out or was processing another request", new Object[0]);
    }

    public boolean isUpdateModelValuesCalled() {
        return this.updateModelValuesCalled;
    }

    public void setUpdateModelValuesCalled(boolean updateModelValuesCalled) {
        this.updateModelValuesCalled = updateModelValuesCalled;
    }

    public int getConcurrentRequestTimeout() {
        return this.concurrentRequestTimeout;
    }

    public void setConcurrentRequestTimeout(int requestWait) {
        this.concurrentRequestTimeout = requestWait;
    }

    public String toString() {
        return "Manager(" + this.currentConversationIdStack + ")";
    }

    protected String getParentConversationIdParameter() {
        return this.parentConversationIdParameter;
    }

    protected void setParentConversationIdParameter(String nestedConversationIdParameter) {
        this.parentConversationIdParameter = nestedConversationIdParameter;
    }
}

