/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.jboss.seam.annotations.FlushModeType;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.Locale;
import org.jboss.seam.core.Pageflow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Page {
    private final String viewId;
    private String description;
    private Integer timeout;
    private Expressions.MethodBinding action;
    private String outcome;
    private String noConversationViewId;
    private String resourceBundleName;
    private boolean switchEnabled = true;
    private List<PageParameter> pageParameters = new ArrayList<PageParameter>();
    private boolean isBeginConversation;
    private boolean isEndConversation;
    private boolean join;
    private boolean nested;
    private FlushModeType flushMode;
    private String pageflow;

    Page(String viewId) {
        int loc;
        this.viewId = viewId;
        if (viewId != null && (loc = viewId.lastIndexOf(46)) > 0 && viewId.startsWith("/")) {
            this.setResourceBundleName(viewId.substring(1, loc));
        }
    }

    ResourceBundle getResourceBundle() {
        String resourceBundleName = this.getResourceBundleName();
        if (resourceBundleName == null) {
            return null;
        }
        try {
            return ResourceBundle.getBundle(resourceBundleName, Locale.instance(), Thread.currentThread().getContextClassLoader());
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    public String toString() {
        return "Page(" + this.getViewId() + ")";
    }

    public String getViewId() {
        return this.viewId;
    }

    public String renderDescription() {
        return Interpolator.instance().interpolate(this.getDescription(), new Object[0]);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setAction(Expressions.MethodBinding action) {
        this.action = action;
    }

    public Expressions.MethodBinding getAction() {
        return this.action;
    }

    public void setOutcome(String outcome) {
        this.outcome = outcome;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public void setNoConversationViewId(String noConversationViewId) {
        this.noConversationViewId = noConversationViewId;
    }

    public String getNoConversationViewId() {
        return this.noConversationViewId;
    }

    public void setResourceBundleName(String resourceBundleName) {
        this.resourceBundleName = resourceBundleName;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setSwitchEnabled(boolean switchEnabled) {
        this.switchEnabled = switchEnabled;
    }

    public boolean isSwitchEnabled() {
        return this.switchEnabled;
    }

    public List<PageParameter> getPageParameters() {
        return this.pageParameters;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public boolean isBeginConversation() {
        return this.isBeginConversation;
    }

    public void setBeginConversation(boolean isBeginConversation) {
        this.isBeginConversation = isBeginConversation;
    }

    public boolean isEndConversation() {
        return this.isEndConversation;
    }

    public void setEndConversation(boolean isEndConversation) {
        this.isEndConversation = isEndConversation;
    }

    public void beginOrEndConversation() {
        if (this.isEndConversation) {
            Conversation.instance().end();
        }
        if (this.isBeginConversation) {
            Conversation.instance().begin(this.join, this.nested);
            if (this.flushMode != null) {
                Conversation.instance().changeFlushMode(this.flushMode);
            }
            if (this.pageflow != null) {
                Pageflow.instance().begin(this.pageflow);
            }
        }
    }

    protected FlushModeType getFlushMode() {
        return this.flushMode;
    }

    protected void setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
    }

    protected boolean isJoin() {
        return this.join;
    }

    protected void setJoin(boolean join) {
        this.join = join;
    }

    protected boolean isNested() {
        return this.nested;
    }

    protected void setNested(boolean nested) {
        this.nested = nested;
    }

    protected String getPageflow() {
        return this.pageflow;
    }

    protected void setPageflow(String pageflow) {
        this.pageflow = pageflow;
    }

    public static final class PageParameter {
        private final String name;
        private Expressions.ValueBinding valueBinding;
        private Expressions.ValueBinding converterValueBinding;
        private String converterId;

        PageParameter(String name) {
            this.name = name;
        }

        Converter getConverter() {
            if (this.converterId != null) {
                return FacesContext.getCurrentInstance().getApplication().createConverter(this.converterId);
            }
            if (this.converterValueBinding != null) {
                return (Converter)this.converterValueBinding.getValue();
            }
            if (this.valueBinding == null) {
                return null;
            }
            Class type = this.valueBinding.getType();
            return FacesContext.getCurrentInstance().getApplication().createConverter(type);
        }

        public String getName() {
            return this.name;
        }

        public void setValueBinding(Expressions.ValueBinding valueBinding) {
            this.valueBinding = valueBinding;
        }

        public Expressions.ValueBinding getValueBinding() {
            return this.valueBinding;
        }

        public void setConverterValueBinding(Expressions.ValueBinding converterValueBinding) {
            this.converterValueBinding = converterValueBinding;
        }

        public Expressions.ValueBinding getConverterValueBinding() {
            return this.converterValueBinding;
        }

        public void setConverterId(String converterId) {
            this.converterId = converterId;
        }

        public String getConverterId() {
            return this.converterId;
        }

        public String toString() {
            return "PageParameter(" + this.name + ")";
        }
    }
}

