/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.FlushModeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.Page;
import org.jboss.seam.core.SafeActions;
import org.jboss.seam.util.DTDEntityResolver;
import org.jboss.seam.util.Parameters;
import org.jboss.seam.util.Resources;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Name(value="org.jboss.seam.core.pages")
@Install(precedence=0)
public class Pages {
    private static final Log log = LogFactory.getLog(Pages.class);
    private Map<String, Page> pagesByViewId = Collections.synchronizedMap(new HashMap());
    private Map<String, List<Page>> pageStacksByViewId = Collections.synchronizedMap(new HashMap());
    private String noConversationViewId;
    private SortedSet<String> wildcardViewIds = new TreeSet<String>(new Comparator<String>(){

        @Override
        public int compare(String x, String y) {
            if (x.length() < y.length()) {
                return -1;
            }
            if (x.length() > y.length()) {
                return 1;
            }
            return x.compareTo(y);
        }
    });

    @Create
    public void initialize() {
        InputStream stream = Resources.getResourceAsStream("/WEB-INF/pages.xml");
        if (stream == null) {
            log.info((Object)"no pages.xml file found");
        } else {
            log.info((Object)"reading pages.xml");
            this.parse(stream);
        }
    }

    private void parse(InputStream stream) {
        Element root = this.getDocumentRoot(stream);
        if (this.noConversationViewId == null) {
            this.noConversationViewId = root.attributeValue("no-conversation-view-id");
        }
        List elements = root.elements("page");
        for (Element page : elements) {
            this.parse(page, page.attributeValue("view-id"));
        }
    }

    private void parse(InputStream stream, String viewId) {
        this.parse(this.getDocumentRoot(stream), viewId);
    }

    private Element getDocumentRoot(InputStream stream) {
        Document doc;
        SAXReader saxReader = new SAXReader();
        saxReader.setEntityResolver((EntityResolver)new DTDEntityResolver());
        saxReader.setMergeAdjacentText(true);
        try {
            doc = saxReader.read(stream);
        }
        catch (DocumentException de) {
            throw new RuntimeException(de);
        }
        Element root = doc.getRootElement();
        return root;
    }

    private void parse(Element page, String viewId) {
        Element beginConversation;
        Element endConversation;
        String timeoutString;
        if (viewId.endsWith("*")) {
            this.wildcardViewIds.add(viewId);
        }
        Page entry = new Page(viewId);
        this.pagesByViewId.put(viewId, entry);
        entry.setSwitchEnabled(!"disabled".equals(page.attributeValue("switch")));
        String description = page.getTextTrim();
        if (description != null && description.length() > 0) {
            entry.setDescription(description);
        }
        if ((timeoutString = page.attributeValue("timeout")) != null) {
            entry.setTimeout(Integer.parseInt(timeoutString));
        }
        String noConversationViewId = page.attributeValue("no-conversation-view-id");
        entry.setNoConversationViewId(noConversationViewId);
        String action = page.attributeValue("action");
        if (action != null) {
            if (action.startsWith("#{")) {
                Expressions.MethodBinding methodBinding = Expressions.instance().createMethodBinding(action);
                entry.setAction(methodBinding);
            } else {
                entry.setOutcome(action);
            }
        }
        if ((endConversation = page.element("end-conversation")) != null) {
            entry.setEndConversation(true);
        }
        if ((beginConversation = page.element("begin-conversation")) != null) {
            entry.setBeginConversation(true);
            entry.setJoin("true".equals(beginConversation.attributeValue("join")));
            entry.setNested("true".equals(beginConversation.attributeValue("nested")));
            entry.setPageflow(beginConversation.attributeValue("pageflow"));
            String flushMode = beginConversation.attributeValue("flush-mode");
            if (flushMode != null) {
                entry.setFlushMode(FlushModeType.valueOf(flushMode.toUpperCase()));
            }
        }
        if (entry.isBeginConversation() && entry.isEndConversation()) {
            throw new IllegalStateException("cannot use both <begin-conversation/> and <end-conversation/>");
        }
        String bundle = page.attributeValue("bundle");
        if (bundle != null) {
            entry.setResourceBundleName(bundle);
        }
        List children = page.elements("param");
        for (Element param : children) {
            String valueExpression = param.attributeValue("value");
            String name = param.attributeValue("name");
            if (name == null) {
                if (valueExpression == null) {
                    throw new IllegalArgumentException("must specify name or value for page <param/> declaration");
                }
                name = valueExpression.substring(2, valueExpression.length() - 1);
            }
            Page.PageParameter pageParameter = new Page.PageParameter(name);
            if (valueExpression != null) {
                pageParameter.setValueBinding(Expressions.instance().createValueBinding(valueExpression));
            }
            pageParameter.setConverterId(param.attributeValue("converterId"));
            String converterExpression = param.attributeValue("converter");
            if (converterExpression != null) {
                pageParameter.setConverterValueBinding(Expressions.instance().createValueBinding(converterExpression));
            }
            entry.getPageParameters().add(pageParameter);
        }
    }

    public Page getPage(String viewId) {
        if (viewId == null) {
            return new Page(viewId);
        }
        Page result = this.getCachedPage(viewId);
        if (result == null) {
            return this.createPage(viewId);
        }
        return result;
    }

    private Page createPage(String viewId) {
        InputStream stream;
        String resourceName = Pages.replaceExtension(viewId, ".page.xml");
        InputStream inputStream = stream = resourceName == null ? null : Resources.getResourceAsStream(resourceName.substring(1));
        if (stream == null) {
            Page result = new Page(viewId);
            this.pagesByViewId.put(viewId, result);
            return result;
        }
        this.parse(stream, viewId);
        return this.getCachedPage(viewId);
    }

    private Page getCachedPage(String viewId) {
        Page result = this.pagesByViewId.get(viewId);
        if (result == null && (viewId = Pages.replaceExtension(viewId, Pages.getSuffix())) != null) {
            result = this.pagesByViewId.get(viewId);
        }
        return result;
    }

    private static String replaceExtension(String viewId, String suffix) {
        int loc = viewId.lastIndexOf(46);
        return loc < 0 ? null : viewId.substring(0, loc) + suffix;
    }

    protected List<Page> getPageStack(String viewId) {
        List<Page> stack = this.pageStacksByViewId.get(viewId);
        if (stack == null) {
            stack = this.createPageStack(viewId);
            this.pageStacksByViewId.put(viewId, stack);
        }
        return stack;
    }

    private List<Page> createPageStack(String viewId) {
        Page page;
        ArrayList<Page> stack = new ArrayList<Page>(1);
        if (viewId != null) {
            for (String wildcard : this.wildcardViewIds) {
                if (!viewId.startsWith(wildcard.substring(0, wildcard.length() - 1))) continue;
                stack.add(this.getPage(wildcard));
            }
        }
        if ((page = this.getPage(viewId)) != null) {
            stack.add(page);
        }
        return stack;
    }

    public boolean callActions(FacesContext facesContext) {
        boolean result = false;
        String viewId = facesContext.getViewRoot().getViewId();
        for (Page page : this.getPageStack(viewId)) {
            result = this.callAction(page, facesContext) || result;
        }
        return result;
    }

    private boolean callAction(Page page, FacesContext facesContext) {
        Expressions.MethodBinding methodBinding;
        String outcome;
        boolean result = false;
        page.beginOrEndConversation();
        String fromAction = outcome = page.getOutcome();
        if (outcome == null && (methodBinding = page.getAction()) != null) {
            fromAction = methodBinding.getExpressionString();
            result = true;
            outcome = Pages.toString(methodBinding.invoke(new Object[0]));
        }
        Pages.handleOutcome(facesContext, outcome, fromAction);
        return result;
    }

    private static String toString(Object returnValue) {
        return returnValue == null ? null : returnValue.toString();
    }

    private static void handleOutcome(FacesContext facesContext, String outcome, String fromAction) {
        if (outcome != null) {
            facesContext.getApplication().getNavigationHandler().handleNavigation(facesContext, fromAction, outcome);
        }
    }

    public static Pages instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application context");
        }
        return (Pages)Component.getInstance(Pages.class, ScopeType.APPLICATION);
    }

    public static boolean callAction(FacesContext facesContext) {
        String actionId;
        String outcome;
        boolean result = false;
        String fromAction = outcome = (String)facesContext.getExternalContext().getRequestParameterMap().get("actionOutcome");
        if (outcome == null && (actionId = (String)facesContext.getExternalContext().getRequestParameterMap().get("actionMethod")) != null) {
            if (!SafeActions.instance().isActionSafe(actionId)) {
                return result;
            }
            String expression = SafeActions.toAction(actionId);
            result = true;
            Expressions.MethodBinding actionBinding = Expressions.instance().createMethodBinding(expression);
            outcome = Pages.toString(actionBinding.invoke(new Object[0]));
            fromAction = expression;
        }
        Pages.handleOutcome(facesContext, outcome, fromAction);
        return result;
    }

    public List<ResourceBundle> getResourceBundles(String viewId) {
        ArrayList<ResourceBundle> result = new ArrayList<ResourceBundle>(1);
        List<Page> stack = this.getPageStack(viewId);
        for (int i = stack.size() - 1; i >= 0; --i) {
            Page page = stack.get(i);
            ResourceBundle bundle = page.getResourceBundle();
            if (bundle == null) continue;
            result.add(bundle);
        }
        return result;
    }

    public Map<String, Object> getConvertedParameters(FacesContext facesContext, String viewId) {
        return this.getConvertedParameters(facesContext, viewId, Collections.EMPTY_SET);
    }

    protected Map<String, Object> getParameters(String viewId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (Page page : this.getPageStack(viewId)) {
            for (Page.PageParameter pageParameter : page.getPageParameters()) {
                Expressions.ValueBinding valueBinding = pageParameter.getValueBinding();
                Object value = valueBinding == null ? Contexts.getPageContext().get(pageParameter.getName()) : valueBinding.getValue();
                if (value == null) continue;
                parameters.put(pageParameter.getName(), value);
            }
        }
        return parameters;
    }

    public Map<String, Object> getConvertedParameters(FacesContext facesContext, String viewId, Set<String> overridden) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (Page page : this.getPageStack(viewId)) {
            for (Page.PageParameter pageParameter : page.getPageParameters()) {
                Converter converter;
                Object value;
                if (overridden.contains(pageParameter.getName())) continue;
                Expressions.ValueBinding valueBinding = pageParameter.getValueBinding();
                if (valueBinding == null) {
                    value = Contexts.getPageContext().get(pageParameter.getName());
                    if (value == null) continue;
                    parameters.put(pageParameter.getName(), value);
                    continue;
                }
                value = valueBinding.getValue();
                if (value == null) continue;
                try {
                    converter = pageParameter.getConverter();
                }
                catch (RuntimeException re) {
                    continue;
                }
                Object convertedValue = converter == null ? value : converter.getAsString(facesContext, (UIComponent)facesContext.getViewRoot(), value);
                parameters.put(pageParameter.getName(), convertedValue);
            }
        }
        return parameters;
    }

    public void applyRequestParameterValues(FacesContext facesContext) {
        String viewId = facesContext.getViewRoot().getViewId();
        Map<String, String[]> requestParameters = Parameters.getRequestParameters();
        for (Page page : this.getPageStack(viewId)) {
            for (Page.PageParameter pageParameter : page.getPageParameters()) {
                Converter converter;
                String[] parameterValues = requestParameters.get(pageParameter.getName());
                if (parameterValues == null || parameterValues.length == 0) continue;
                if (parameterValues.length > 1) {
                    throw new IllegalArgumentException("page parameter may not be multi-valued: " + pageParameter.getName());
                }
                String stringValue = parameterValues[0];
                try {
                    converter = pageParameter.getConverter();
                }
                catch (RuntimeException re) {
                    continue;
                }
                String value = converter == null ? stringValue : converter.getAsObject(facesContext, (UIComponent)facesContext.getViewRoot(), stringValue);
                Expressions.ValueBinding valueBinding = pageParameter.getValueBinding();
                if (valueBinding == null) {
                    Contexts.getPageContext().set(pageParameter.getName(), value);
                    continue;
                }
                valueBinding.setValue(value);
            }
        }
    }

    public void applyViewRootValues(FacesContext facesContext) {
        String viewId = facesContext.getViewRoot().getViewId();
        for (Page page : this.getPageStack(viewId)) {
            for (Page.PageParameter pageParameter : page.getPageParameters()) {
                Object object;
                Expressions.ValueBinding valueBinding = pageParameter.getValueBinding();
                if (valueBinding == null || (object = Contexts.getPageContext().get(pageParameter.getName())) == null) continue;
                valueBinding.setValue(object);
            }
        }
    }

    public String getNoConversationViewId() {
        return this.noConversationViewId;
    }

    public void setNoConversationViewId(String noConversationViewId) {
        this.noConversationViewId = noConversationViewId;
    }

    public String encodePageParameters(FacesContext facesContext, String url, String viewId) {
        Map<String, Object> parameters = this.getConvertedParameters(facesContext, viewId);
        return Manager.instance().encodeParameters(url, parameters);
    }

    public void storePageParameters(FacesContext facesContext) {
        String viewId = facesContext.getViewRoot().getViewId();
        for (Map.Entry<String, Object> param : this.getParameters(viewId).entrySet()) {
            Contexts.getPageContext().set(param.getKey(), param.getValue());
        }
    }

    public String getNoConversationViewId(String viewId) {
        List<Page> stack = this.getPageStack(viewId);
        for (int i = stack.size() - 1; i >= 0; --i) {
            Page page = stack.get(i);
            String noConversationViewId = page.getNoConversationViewId();
            if (noConversationViewId == null) continue;
            return noConversationViewId;
        }
        return this.noConversationViewId;
    }

    public Integer getTimeout(String viewId) {
        List<Page> stack = this.getPageStack(viewId);
        for (int i = stack.size() - 1; i >= 0; --i) {
            Page page = stack.get(i);
            Integer timeout = page.getTimeout();
            if (timeout == null) continue;
            return timeout;
        }
        return Manager.instance().getConversationTimeout();
    }

    public static String getSuffix() {
        String defaultSuffix = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
        return defaultSuffix == null ? ".jsp" : defaultSuffix;
    }
}

