/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import java.util.TimeZone;
import javax.faces.context.FacesContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.AbstractMutable;

@Scope(value=ScopeType.SESSION)
@Name(value="org.jboss.seam.core.timeZoneSelector")
@Intercept(value=InterceptionType.NEVER)
@Install(value=false, precedence=0)
public class TimeZoneSelector
extends AbstractMutable
implements Serializable {
    private String id;
    private boolean cookieEnabled;
    private int cookieMaxAge = 31536000;

    @Create
    public void initTimeZone() {
        Cookie cookie;
        if (this.cookieEnabled && (cookie = (Cookie)FacesContext.getCurrentInstance().getExternalContext().getRequestCookieMap().get("org.jboss.seam.core.TimeZone")) != null) {
            this.setTimeZoneId(cookie.getValue());
        }
    }

    public void select() {
        if (this.cookieEnabled) {
            HttpServletResponse response = (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
            Cookie cookie = new Cookie("org.jboss.seam.core.TimeZone", this.getTimeZoneId());
            cookie.setMaxAge(this.cookieMaxAge);
            response.addCookie(cookie);
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        this.setTimeZoneId(timeZone.getID());
    }

    public void setTimeZoneId(String id) {
        this.setDirty(this.id, id);
        this.id = id;
    }

    public String getTimeZoneId() {
        return this.id;
    }

    public TimeZone getTimeZone() {
        if (this.id == null) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(this.getTimeZoneId());
    }

    public static TimeZoneSelector instance() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No active session context");
        }
        return (TimeZoneSelector)Component.getInstance(TimeZoneSelector.class, ScopeType.SESSION);
    }

    public boolean isCookieEnabled() {
        return this.cookieEnabled;
    }

    public void setCookieEnabled(boolean cookieEnabled) {
        this.setDirty(this.cookieEnabled, cookieEnabled);
        this.cookieEnabled = cookieEnabled;
    }

    protected int getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    protected void setCookieMaxAge(int cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }
}

