/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.annotations.Namespace;
import org.jboss.seam.deployment.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceScanner
extends Scanner {
    private static final Log log = LogFactory.getLog(NamespaceScanner.class);
    private Set<Package> packages;

    public NamespaceScanner(String resourceName) {
        super(resourceName);
    }

    public NamespaceScanner(String resourceName, ClassLoader classLoader) {
        super(resourceName, classLoader);
    }

    public Set<Package> getPackages() {
        if (this.packages == null) {
            this.packages = new HashSet<Package>();
            this.scan();
        }
        return this.packages;
    }

    public static String filenameToPackageName(String filename) {
        return filename.substring(0, filename.lastIndexOf("/package-info.class")).replace('/', '.').replace('\\', '.');
    }

    @Override
    protected void handleItem(String name) {
        if (name.endsWith("/package-info.class")) {
            String packageName = NamespaceScanner.filenameToPackageName(name);
            Package pkg = this.getPackage(packageName);
            if (pkg == null) {
                log.warn((Object)("Cannot load package Dinfo for " + packageName));
            } else if (pkg.getAnnotation(Namespace.class) != null) {
                this.packages.add(pkg);
            }
        }
    }

    protected Package getPackage(String name) {
        try {
            Class<?> c = this.classLoader.loadClass(name + ".package-info");
            return c != null ? c.getPackage() : null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

