/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.framework;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.framework.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityQuery
extends Query {
    private EntityManager entityManager;
    private List resultList;
    private Object singleResult;
    private Long resultCount;
    private Map<String, String> hints;

    @Override
    public void validate() {
        super.validate();
        if (this.getEntityManager() == null) {
            throw new IllegalStateException("entityManager is null");
        }
    }

    @Override
    @Transactional
    public List getResultList() {
        if (this.resultList == null) {
            javax.persistence.Query query = this.createQuery();
            this.resultList = query == null ? null : query.getResultList();
        }
        return this.resultList;
    }

    @Override
    @Transactional
    public Object getSingleResult() {
        if (this.singleResult == null) {
            javax.persistence.Query query = this.createQuery();
            this.singleResult = query == null ? null : query.getSingleResult();
        }
        return this.singleResult;
    }

    @Override
    @Transactional
    public Long getResultCount() {
        if (this.resultCount == null) {
            javax.persistence.Query query = this.createCountQuery();
            this.resultCount = query == null ? null : (Long)query.getSingleResult();
        }
        return this.resultCount;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.resultCount = null;
        this.resultList = null;
        this.singleResult = null;
    }

    public EntityManager getEntityManager() {
        if (this.entityManager == null) {
            this.entityManager = (EntityManager)Component.getInstance("entityManager");
        }
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    protected javax.persistence.Query createQuery() {
        this.parseEjbql();
        this.getEntityManager().joinTransaction();
        javax.persistence.Query query = this.getEntityManager().createQuery(this.getRenderedEjbql());
        this.setParameters(query, this.getQueryParameters(), 0);
        this.setParameters(query, this.getRestrictionParameters(), this.getQueryParameters().size());
        if (this.getFirstResult() != null) {
            query.setFirstResult(this.getFirstResult().intValue());
        }
        if (this.getMaxResults() != null) {
            query.setMaxResults(this.getMaxResults().intValue());
        }
        if (this.getHints() != null) {
            for (Map.Entry<String, String> me : this.getHints().entrySet()) {
                query.setHint(me.getKey(), (Object)me.getValue());
            }
        }
        return query;
    }

    protected javax.persistence.Query createCountQuery() {
        this.parseEjbql();
        this.getEntityManager().joinTransaction();
        javax.persistence.Query query = this.getEntityManager().createQuery(this.getCountEjbql());
        this.setParameters(query, this.getQueryParameters(), 0);
        this.setParameters(query, this.getRestrictionParameters(), this.getQueryParameters().size());
        return query;
    }

    private void setParameters(javax.persistence.Query query, List<Expressions.ValueBinding> parameters, int start) {
        for (int i = 0; i < parameters.size(); ++i) {
            Object parameterValue = parameters.get(i).getValue();
            if (parameterValue == null) continue;
            query.setParameter("p" + (start + i), parameterValue);
        }
    }

    public Map<String, String> getHints() {
        return this.hints;
    }

    public void setHints(Map<String, String> hints) {
        this.hints = hints;
    }
}

