/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.framework;

import java.io.Serializable;
import org.hibernate.Session;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.framework.Home;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateEntityHome<E>
extends Home<E> {
    private Session session;

    @Override
    public void create() {
        super.create();
        if (this.getSession() == null) {
            throw new IllegalStateException("session is null");
        }
    }

    @Transactional
    public boolean isManaged() {
        return this.getInstance() != null && this.getSession().contains(this.getInstance());
    }

    @Transactional
    public String update() {
        this.getSession().flush();
        this.updatedMessage();
        return "updated";
    }

    @Transactional
    public String persist() {
        this.getSession().persist(this.getInstance());
        this.getSession().flush();
        this.setId(this.getSession().getIdentifier(this.getInstance()));
        this.createdMessage();
        return "persisted";
    }

    @Transactional
    public String remove() {
        this.getSession().delete(this.getInstance());
        this.getSession().flush();
        this.deletedMessage();
        return "removed";
    }

    @Override
    @Transactional
    public E find() {
        Object result = this.getSession().get(this.getEntityClass(), (Serializable)this.getId());
        if (result == null) {
            result = this.handleNotFound();
        }
        return (E)result;
    }

    public Session getSession() {
        if (this.session == null) {
            this.session = (Session)Component.getInstance("session");
        }
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }
}

