/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.framework;

import java.util.List;
import org.hibernate.Session;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.framework.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateEntityQuery
extends Query {
    private Session session;
    private List resultList;
    private Object singleResult;
    private Integer resultCount;
    private Boolean cacheable;
    private String cacheRegion;
    private Integer fetchSize;

    @Override
    public void validate() {
        super.validate();
        if (this.getSession() == null) {
            throw new IllegalStateException("session is null");
        }
    }

    @Override
    @Transactional
    public List getResultList() {
        if (this.resultList == null) {
            org.hibernate.Query query = this.createQuery();
            this.resultList = query == null ? null : query.list();
        }
        return this.resultList;
    }

    @Override
    @Transactional
    public Object getSingleResult() {
        if (this.singleResult == null) {
            org.hibernate.Query query = this.createQuery();
            this.singleResult = query == null ? null : query.uniqueResult();
        }
        return this.singleResult;
    }

    @Override
    @Transactional
    public Long getResultCount() {
        if (this.resultCount == null) {
            org.hibernate.Query query = this.createCountQuery();
            this.resultCount = query == null ? null : (Integer)query.uniqueResult();
        }
        return this.resultCount.longValue();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.resultCount = null;
        this.resultList = null;
        this.singleResult = null;
    }

    public Session getSession() {
        if (this.session == null) {
            this.session = (Session)Component.getInstance("session");
        }
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    protected org.hibernate.Query createQuery() {
        this.parseEjbql();
        org.hibernate.Query query = this.getSession().createQuery(this.getRenderedEjbql());
        this.setParameters(query, this.getQueryParameters(), 0);
        this.setParameters(query, this.getRestrictionParameters(), this.getQueryParameters().size());
        if (this.getFirstResult() != null) {
            query.setFirstResult(this.getFirstResult().intValue());
        }
        if (this.getMaxResults() != null) {
            query.setMaxResults(this.getMaxResults().intValue());
        }
        if (this.getCacheable() != null) {
            query.setCacheable(this.getCacheable().booleanValue());
        }
        if (this.getCacheRegion() != null) {
            query.setCacheRegion(this.getCacheRegion());
        }
        if (this.getFetchSize() != null) {
            query.setFetchSize(this.getFetchSize().intValue());
        }
        return query;
    }

    protected org.hibernate.Query createCountQuery() {
        this.parseEjbql();
        org.hibernate.Query query = this.getSession().createQuery(this.getCountEjbql());
        this.setParameters(query, this.getQueryParameters(), 0);
        this.setParameters(query, this.getRestrictionParameters(), this.getQueryParameters().size());
        return query;
    }

    private void setParameters(org.hibernate.Query query, List<Expressions.ValueBinding> parameters, int start) {
        for (int i = 0; i < parameters.size(); ++i) {
            Object parameterValue = parameters.get(i).getValue();
            if (parameterValue == null) continue;
            query.setParameter("p" + (start + i), parameterValue);
        }
    }

    protected Boolean getCacheable() {
        return this.cacheable;
    }

    protected void setCacheable(Boolean cacheable) {
        this.cacheable = cacheable;
    }

    protected String getCacheRegion() {
        return this.cacheRegion;
    }

    protected void setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
    }

    protected Integer getFetchSize() {
        return this.fetchSize;
    }

    protected void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }
}

