/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.intercept;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptorType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.intercept.EJBInvocationContext;
import org.jboss.seam.intercept.EventType;
import org.jboss.seam.intercept.RootInterceptor;

public class SessionBeanInterceptor
extends RootInterceptor {
    private static final Log log = LogFactory.getLog(SessionBeanInterceptor.class);
    public static ThreadLocal<Component> COMPONENT = new ThreadLocal();

    public SessionBeanInterceptor() {
        super(InterceptorType.SERVER);
    }

    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        return this.invoke(new EJBInvocationContext(invocation), EventType.AROUND_INVOKE);
    }

    @PrePassivate
    public void prePassivate(InvocationContext invocation) {
        this.invokeAndHandle(new EJBInvocationContext(invocation), EventType.PRE_PASSIVATE);
    }

    @PostActivate
    public void postActivate(InvocationContext invocation) {
        this.invokeAndHandle(new EJBInvocationContext(invocation), EventType.POST_ACTIVATE);
    }

    @PreDestroy
    public void preDestroy(InvocationContext invocation) {
        this.invokeAndHandle(new EJBInvocationContext(invocation), EventType.PRE_DESTORY);
    }

    @PostConstruct
    public void postConstruct(InvocationContext invocation) {
        Component invokingComponent = COMPONENT.get();
        Object bean = invocation.getTarget();
        if (invokingComponent != null && invokingComponent.getBeanClass().isInstance(bean)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("post construct phase for instance of component: " + invokingComponent.getName()));
            }
            this.init(invokingComponent);
        } else if (bean.getClass().isAnnotationPresent(Name.class)) {
            String defaultComponentName = bean.getClass().getAnnotation(Name.class).value();
            if (log.isTraceEnabled()) {
                log.trace((Object)("post construct phase for component instantiated outside Seam, assuming default role: " + defaultComponentName));
            }
            this.init(Seam.componentForName(defaultComponentName));
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)"post construct phase for non-component bean");
            }
            this.initNonSeamComponent();
        }
        this.postConstruct(bean);
        this.invokeAndHandle(new EJBInvocationContext(invocation), EventType.POST_CONSTRUCT);
    }
}

