/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.interceptors;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.annotations.AroundInvoke;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Interceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.interceptors.AbstractInterceptor;
import org.jboss.seam.util.EJB;

@Interceptor(stateless=true)
public class BijectionInterceptor
extends AbstractInterceptor {
    private static final Log log = LogFactory.getLog(BijectionInterceptor.class);

    private static boolean isLifecycleMethod(Method method) {
        return method == null || method.isAnnotationPresent(Create.class) || method.isAnnotationPresent(Destroy.class) || method.isAnnotationPresent(EJB.POST_CONSTRUCT) || method.isAnnotationPresent(EJB.PRE_DESTROY) || method.isAnnotationPresent(EJB.PRE_PASSIVATE) || method.isAnnotationPresent(EJB.POST_ACTIVATE);
    }

    @AroundInvoke
    public Object bijectTargetComponent(InvocationContext invocation) throws Exception {
        if (this.getComponent().needsInjection()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("injecting dependencies of: " + this.getComponent().getName()));
            }
            this.getComponent().inject(invocation.getTarget(), !BijectionInterceptor.isLifecycleMethod(invocation.getMethod()));
        }
        Object result = invocation.proceed();
        if (this.getComponent().needsOutjection()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("outjecting dependencies of: " + this.getComponent().getName()));
            }
            this.getComponent().outject(invocation.getTarget(), !BijectionInterceptor.isLifecycleMethod(invocation.getMethod()));
        }
        if (this.getComponent().needsInjection()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("disinjecting dependencies of: " + this.getComponent().getName()));
            }
            this.getComponent().disinject(invocation.getTarget());
        }
        return result;
    }
}

