/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.interceptors;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.annotations.AroundInvoke;
import org.jboss.seam.annotations.BeginTask;
import org.jboss.seam.annotations.CreateProcess;
import org.jboss.seam.annotations.EndTask;
import org.jboss.seam.annotations.Interceptor;
import org.jboss.seam.annotations.ResumeProcess;
import org.jboss.seam.annotations.StartTask;
import org.jboss.seam.annotations.Transition;
import org.jboss.seam.core.BusinessProcess;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.interceptors.AbstractInterceptor;
import org.jboss.seam.interceptors.BijectionInterceptor;
import org.jboss.seam.interceptors.OutcomeInterceptor;
import org.jboss.seam.interceptors.ValidationInterceptor;

@Interceptor(stateless=true, around={ValidationInterceptor.class, BijectionInterceptor.class, OutcomeInterceptor.class})
public class BusinessProcessInterceptor
extends AbstractInterceptor {
    private static final Log log = LogFactory.getLog(BusinessProcessInterceptor.class);

    @AroundInvoke
    public Object manageBusinessProcessContext(InvocationContext invocation) throws Exception {
        if (!this.beforeInvocation(invocation)) {
            return null;
        }
        return this.afterInvocation(invocation, invocation.proceed());
    }

    private boolean beforeInvocation(InvocationContext invocationContext) {
        Method method = invocationContext.getMethod();
        if (method.isAnnotationPresent(StartTask.class)) {
            log.trace((Object)"encountered @StartTask");
            StartTask tag = method.getAnnotation(StartTask.class);
            Long taskId = this.getRequestParamValueAsLong(tag.taskIdParameter());
            return BusinessProcess.instance().resumeTask(taskId);
        }
        if (method.isAnnotationPresent(BeginTask.class)) {
            log.trace((Object)"encountered @BeginTask");
            BeginTask tag = method.getAnnotation(BeginTask.class);
            Long taskId = this.getRequestParamValueAsLong(tag.taskIdParameter());
            return BusinessProcess.instance().resumeTask(taskId);
        }
        if (method.isAnnotationPresent(ResumeProcess.class)) {
            log.trace((Object)"encountered @ResumeProcess");
            ResumeProcess tag = method.getAnnotation(ResumeProcess.class);
            Long processId = this.getRequestParamValueAsLong(tag.processIdParameter());
            return BusinessProcess.instance().resumeProcess(processId);
        }
        if (method.isAnnotationPresent(EndTask.class)) {
            log.trace((Object)"encountered @EndTask");
            return BusinessProcess.instance().validateTask();
        }
        return true;
    }

    private Object afterInvocation(InvocationContext invocation, Object result) {
        Method method = invocation.getMethod();
        if (result != null || method.getReturnType().equals(Void.TYPE)) {
            if (method.isAnnotationPresent(CreateProcess.class)) {
                log.trace((Object)"encountered @CreateProcess");
                CreateProcess tag = method.getAnnotation(CreateProcess.class);
                BusinessProcess.instance().createProcess(tag.definition());
            }
            if (method.isAnnotationPresent(StartTask.class)) {
                log.trace((Object)"encountered @StartTask");
                BusinessProcess.instance().startTask();
            }
            if (method.isAnnotationPresent(EndTask.class)) {
                log.trace((Object)"encountered @EndTask");
                BusinessProcess.instance().endTask(method.getAnnotation(EndTask.class).transition());
            }
            if (method.isAnnotationPresent(Transition.class)) {
                log.trace((Object)"encountered @Transition");
                String transitionName = method.getAnnotation(Transition.class).value();
                if ("".equals(transitionName)) {
                    transitionName = method.getName();
                }
                BusinessProcess.instance().transition(transitionName);
            }
        }
        return result;
    }

    private Long getRequestParamValueAsLong(String paramName) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        String paramValue = (String)paramMap.get(paramName);
        if (paramValue == null) {
            throw new IllegalStateException("no value for request parameter: " + paramName);
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(Long.class);
        if (editor != null) {
            editor.setAsText(paramValue);
            return (Long)editor.getValue();
        }
        return Long.parseLong(paramValue);
    }
}

