/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.interceptors;

import java.lang.reflect.Method;
import javax.faces.application.FacesMessage;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.annotations.AroundInvoke;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.BeginTask;
import org.jboss.seam.annotations.Conversational;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Interceptor;
import org.jboss.seam.annotations.StartTask;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.core.Manager;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.interceptors.AbstractInterceptor;
import org.jboss.seam.interceptors.BijectionInterceptor;
import org.jboss.seam.interceptors.BusinessProcessInterceptor;
import org.jboss.seam.interceptors.OutcomeInterceptor;
import org.jboss.seam.interceptors.ValidationInterceptor;

@Interceptor(stateless=true, around={ValidationInterceptor.class, BijectionInterceptor.class, OutcomeInterceptor.class, BusinessProcessInterceptor.class})
public class ConversationalInterceptor
extends AbstractInterceptor {
    private static final Log log = LogFactory.getLog(ConversationalInterceptor.class);

    @AroundInvoke
    public Object checkConversationForConversationalBean(InvocationContext invocation) throws Exception {
        Method method = invocation.getMethod();
        if (this.isNoConversationForConversationalBean(method)) {
            String outcome;
            String string = outcome = this.methodIsConversational(method) ? method.getAnnotation(Conversational.class).ifNotBegunOutcome() : this.getComponent().getBeanClass().getAnnotation(Conversational.class).ifNotBegunOutcome();
            if ("".equals(outcome)) {
                throw new IllegalStateException("no long-running conversation for @Conversational bean: " + this.getComponent().getName());
            }
            if (Lifecycle.getPhaseId() == PhaseId.INVOKE_APPLICATION) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("no long-running conversation for @Conversational bean: " + this.getComponent().getName()));
                }
                FacesMessages.instance().addFromResourceBundle(FacesMessage.SEVERITY_WARN, "org.jboss.seam.NoConversation", "No conversation", new Object[0]);
                if (method.getReturnType().equals(String.class)) {
                    return outcome;
                }
                if (method.getReturnType().equals(Void.TYPE)) {
                    return null;
                }
            }
        }
        return invocation.proceed();
    }

    private boolean isNoConversationForConversationalBean(Method method) {
        boolean classlevelViolation;
        boolean bl = classlevelViolation = this.componentIsConversational() && (!Manager.instance().isLongRunningOrNestedConversation() || this.componentShouldBeInitiator() && !this.componentIsInitiator()) && !method.isAnnotationPresent(Begin.class) && !method.isAnnotationPresent(StartTask.class) && !method.isAnnotationPresent(BeginTask.class) && !method.isAnnotationPresent(Destroy.class) && !method.isAnnotationPresent(Create.class);
        if (classlevelViolation) {
            return true;
        }
        boolean methodlevelViolation = this.methodIsConversational(method) && (!Manager.instance().isLongRunningOrNestedConversation() || this.componentShouldBeInitiator(method) && !this.componentIsInitiator());
        return methodlevelViolation;
    }

    private boolean methodIsConversational(Method method) {
        return method.isAnnotationPresent(Conversational.class);
    }

    private boolean componentShouldBeInitiator(Method method) {
        return method.getAnnotation(Conversational.class).initiator();
    }

    private boolean componentIsConversational() {
        return this.getComponent().getBeanClass().isAnnotationPresent(Conversational.class);
    }

    private boolean componentShouldBeInitiator() {
        return this.getComponent().getBeanClass().getAnnotation(Conversational.class).initiator();
    }

    private boolean componentIsInitiator() {
        return this.getComponent().getName().equals(Manager.instance().getCurrentConversationInitiator());
    }
}

