/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.interceptors;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jboss.seam.annotations.AroundInvoke;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Interceptor;
import org.jboss.seam.contexts.PassivatedEntity;
import org.jboss.seam.core.PersistenceContexts;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.interceptors.AbstractInterceptor;
import org.jboss.seam.interceptors.BijectionInterceptor;
import org.jboss.seam.util.Reflections;

@Interceptor(around={BijectionInterceptor.class})
public class ManagedEntityIdentityInterceptor
extends AbstractInterceptor {
    private List<PassivatedEntity> list = new ArrayList<PassivatedEntity>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object aroundInvoke(InvocationContext ctx) throws Exception {
        this.entityIdsToRefs(ctx);
        try {
            Object object = ctx.proceed();
            return object;
        }
        finally {
            this.entityRefsToIds(ctx);
        }
    }

    public void entityRefsToIds(InvocationContext ctx) throws Exception {
        PersistenceContexts touchedContexts = PersistenceContexts.instance();
        if (touchedContexts != null && touchedContexts.getTouchedContexts().size() > 0) {
            Object bean = ctx.getTarget();
            for (Class<?> beanClass = bean.getClass(); beanClass != Object.class; beanClass = beanClass.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = beanClass.getDeclaredFields()) {
                    PassivatedEntity pi;
                    Object value;
                    boolean ignoreField;
                    boolean bl = ignoreField = Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || field.isAnnotationPresent(In.class);
                    if (ignoreField) continue;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    if ((value = Reflections.get(field, bean)) == null || (pi = PassivatedEntity.createPassivatedEntity(value, field.getName())) == null) continue;
                    this.list.add(pi);
                    Reflections.set(field, bean, null);
                }
            }
        }
    }

    public void entityIdsToRefs(InvocationContext ctx) throws Exception {
        if (this.list.size() > 0) {
            Object bean = ctx.getTarget();
            Class<?> beanClass = bean.getClass();
            block2: for (PassivatedEntity pe : this.list) {
                Object reference = pe.toEntityReference();
                if (reference == null) continue;
                while (beanClass != Object.class) {
                    try {
                        Field field = beanClass.getDeclaredField(pe.getFieldName());
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        field.set(bean, reference);
                        continue block2;
                    }
                    catch (NoSuchFieldException nsfe) {
                        beanClass = beanClass.getSuperclass();
                    }
                }
            }
        }
        this.list.clear();
    }
}

