/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.interceptors;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.ApplicationException;
import javax.ejb.Remove;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.InterceptorType;
import org.jboss.seam.annotations.AroundInvoke;
import org.jboss.seam.annotations.Interceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.interceptors.AbstractInterceptor;

@Interceptor(type=InterceptorType.CLIENT)
public class RemoveInterceptor
extends AbstractInterceptor {
    private static final Log log = LogFactory.getLog(RemoveInterceptor.class);

    @AroundInvoke
    public Object removeIfNecessary(InvocationContext invocation) throws Exception {
        Object result;
        Method removeMethod = this.getComponent().getRemoveMethod(invocation.getMethod().getName());
        try {
            result = invocation.proceed();
        }
        catch (Exception exception) {
            this.removeIfNecessary(removeMethod, exception);
            throw exception;
        }
        this.removeIfNecessary(removeMethod);
        return result;
    }

    private void removeIfNecessary(Method removeMethod, Exception exception) {
        if (exception instanceof RuntimeException || exception instanceof RemoteException) {
            if (!exception.getClass().isAnnotationPresent(ApplicationException.class)) {
                this.remove();
            }
        } else if (removeMethod != null && !removeMethod.getAnnotation(Remove.class).retainIfException()) {
            this.remove();
        }
    }

    private void removeIfNecessary(Method removeMethod) {
        if (removeMethod != null) {
            this.remove();
        }
    }

    private void remove() {
        this.getComponent().getScope().getContext().remove(this.getComponent().getName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stateful component was removed: " + this.getComponent().getName()));
        }
    }
}

