/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms;

import javax.jms.JMSException;
import javax.jms.TopicConnectionFactory;
import javax.naming.NamingException;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.jms.ManagedTopicPublisher;
import org.jboss.seam.util.Naming;

@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Name(value="org.jboss.seam.jms.topicConnection")
@Install(precedence=0, genericDependencies={ManagedTopicPublisher.class})
public class TopicConnection {
    private String topicConnectionFactoryJndiName = "UIL2ConnectionFactory";
    private javax.jms.TopicConnection topicConnection;

    public String getTopicConnectionFactoryJndiName() {
        return this.topicConnectionFactoryJndiName;
    }

    public void setTopicConnectionFactoryJndiName(String jndiName) {
        this.topicConnectionFactoryJndiName = jndiName;
    }

    @Create
    public void init() throws NamingException, JMSException {
        this.topicConnection = this.getTopicConnectionFactory().createTopicConnection();
        this.topicConnection.start();
    }

    @Destroy
    public void destroy() throws JMSException {
        this.topicConnection.stop();
        this.topicConnection.close();
    }

    private TopicConnectionFactory getTopicConnectionFactory() throws NamingException {
        return (TopicConnectionFactory)Naming.getInitialContext().lookup(this.topicConnectionFactoryJndiName);
    }

    @Unwrap
    public javax.jms.TopicConnection getTopicConnection() {
        return this.topicConnection;
    }

    public static javax.jms.TopicConnection instance() {
        return (javax.jms.TopicConnection)Component.getInstance(TopicConnection.class, true);
    }

    public String toString() {
        return "TopicConnection(" + this.topicConnectionFactoryJndiName + ")";
    }
}

