/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.model.DataModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.ContextAdaptor;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.ConversationList;
import org.jboss.seam.core.ConversationStack;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.core.FacesPage;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.Pageflow;
import org.jboss.seam.core.Pages;
import org.jboss.seam.core.Switcher;
import org.jboss.seam.util.Transactions;

public abstract class AbstractSeamPhaseListener
implements PhaseListener {
    private static final Log log = LogFactory.getLog(AbstractSeamPhaseListener.class);
    private static boolean exists = false;

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void afterRestoreView(FacesContext facesContext) {
        Lifecycle.resumePage();
        Map parameters = facesContext.getExternalContext().getRequestParameterMap();
        boolean conversationFound = Manager.instance().restoreConversation(parameters);
        Lifecycle.resumeConversation(facesContext.getExternalContext());
        if (!conversationFound) {
            Manager.instance().redirectToNoConversationView();
        }
        if (Init.instance().isJbpmInstalled()) {
            Pageflow.instance().validatePageflow();
        }
        Manager.instance().handleConversationPropagation(parameters);
        if (log.isDebugEnabled()) {
            log.debug((Object)("After restoring conversation context: " + Contexts.getConversationContext()));
        }
    }

    private void selectDataModelRow(Map parameters) {
        String dataModelSelection = (String)parameters.get("dataModelSelection");
        if (dataModelSelection != null) {
            int colonLoc = dataModelSelection.indexOf(58);
            int bracketLoc = dataModelSelection.indexOf(91);
            if (colonLoc > 0 && bracketLoc > colonLoc) {
                String var = dataModelSelection.substring(0, colonLoc);
                String name = dataModelSelection.substring(colonLoc + 1, bracketLoc);
                int index = Integer.parseInt(dataModelSelection.substring(bracketLoc + 1, dataModelSelection.length() - 1));
                Object value = Contexts.lookupInStatefulContexts(name);
                if (value != null) {
                    DataModel dataModel = (DataModel)value;
                    if (index < dataModel.getRowCount()) {
                        dataModel.setRowIndex(index);
                        Contexts.getEventContext().set(var, dataModel.getRowData());
                    } else {
                        log.warn((Object)"DataModel row was unavailable");
                        Contexts.getEventContext().remove(var);
                    }
                }
            }
        }
    }

    public void beforePhase(PhaseEvent event) {
        if (Contexts.isApplicationContextActive()) {
            Events.instance().raiseEvent("org.jboss.seam.beforePhase", event);
        }
        if (Contexts.isConversationContextActive() && Init.instance().isJbpmInstalled() && Pageflow.instance().isInProcess()) {
            String name;
            PhaseId phaseId = event.getPhaseId();
            if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                name = "process-validations";
            } else if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                name = "update-model-values";
            } else if (phaseId == PhaseId.INVOKE_APPLICATION) {
                name = "invoke-application";
            } else if (phaseId == PhaseId.RENDER_RESPONSE) {
                name = "render-response";
            } else {
                return;
            }
            Pageflow.instance().processEvents(name);
        }
    }

    public void afterPhase(PhaseEvent event) {
        if (Contexts.isApplicationContextActive()) {
            Events.instance().raiseEvent("org.jboss.seam.afterPhase", event);
        }
    }

    protected void beforeUpdateModelValues(PhaseEvent event) {
        Pages.instance().applyViewRootValues(event.getFacesContext());
        Manager.instance().setUpdateModelValuesCalled(true);
    }

    protected void afterInvokeApplication() {
    }

    protected void addTransactionFailedMessage() {
        try {
            if (Transactions.isTransactionMarkedRollback()) {
                FacesMessages.instance().addFromResourceBundle(FacesMessage.SEVERITY_WARN, "org.jboss.seam.TransactionFailed", "Transaction failed", new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void beforeRender(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        if (!Manager.instance().isUpdateModelValuesCalled()) {
            Pages.instance().applyRequestParameterValues(facesContext);
        }
        if (Contexts.isPageContextActive()) {
            Context pageContext = Contexts.getPageContext();
            pageContext.flush();
            pageContext.remove(Seam.getComponentName(ConversationList.class));
            pageContext.remove(Seam.getComponentName(Switcher.class));
            pageContext.remove(Seam.getComponentName(ConversationStack.class));
        }
        this.selectDataModelRow(facesContext.getExternalContext().getRequestParameterMap());
        this.callPageActions(event);
        if (facesContext.getResponseComplete()) {
            if (Init.instance().isMyFacesLifecycleBug()) {
                Lifecycle.endRequest(facesContext.getExternalContext());
            }
        } else {
            FacesMessages.instance().beforeRenderResponse();
            Manager.instance().prepareBackswitch(facesContext);
        }
        FacesPage.instance().storeConversation();
        FacesPage.instance().storePageflow();
    }

    protected void afterRender(FacesContext facesContext) {
        Manager.instance().prepareBackswitch(facesContext);
        ExternalContext externalContext = facesContext.getExternalContext();
        Manager.instance().endRequest(ContextAdaptor.getSession(externalContext));
        Lifecycle.endRequest(externalContext);
    }

    protected void afterResponseComplete(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Manager.instance().endRequest(ContextAdaptor.getSession(externalContext));
        Lifecycle.endRequest(facesContext.getExternalContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean callPageActions(PhaseEvent event) {
        Lifecycle.setPhaseId(PhaseId.INVOKE_APPLICATION);
        boolean actionsWereCalled = false;
        try {
            FacesContext facesContext = event.getFacesContext();
            actionsWereCalled = Pages.callAction(facesContext) || actionsWereCalled;
            boolean bl = actionsWereCalled = Pages.instance().callActions(facesContext) || actionsWereCalled;
            return bl;
        }
        catch (RuntimeException re) {
            log.error((Object)"Swallowing exception thrown by page action", (Throwable)re);
            boolean bl = actionsWereCalled;
            return bl;
        }
        finally {
            Lifecycle.setPhaseId(PhaseId.RENDER_RESPONSE);
            if (actionsWereCalled) {
                FacesMessages.afterPhase();
                this.handleTransactionsAfterPageActions(event);
            }
        }
    }

    protected void handleTransactionsAfterPageActions(PhaseEvent event) {
    }

    protected AbstractSeamPhaseListener() {
        if (exists) {
            log.warn((Object)"There should only be one Seam phase listener per application");
        }
        exists = true;
    }

    void begin(PhaseId phaseId) {
        try {
            if (!Transactions.isTransactionActiveOrMarkedRollback()) {
                log.debug((Object)("beginning transaction prior to phase: " + phaseId));
                Transactions.getUserTransaction().begin();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not start transaction", e);
        }
    }

    void commitOrRollback(PhaseId phaseId) {
        try {
            if (Transactions.isTransactionActive()) {
                log.debug((Object)("committing transaction after phase: " + phaseId));
                Transactions.getUserTransaction().commit();
            } else if (Transactions.isTransactionMarkedRollback()) {
                log.debug((Object)("rolling back transaction after phase: " + phaseId));
                Transactions.getUserTransaction().rollback();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not commit transaction", e);
        }
    }
}

