/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.jsf.AbstractSeamPhaseListener;

public class SeamPhaseListener
extends AbstractSeamPhaseListener {
    private static final Log log = LogFactory.getLog(SeamPhaseListener.class);

    public void beforePhase(PhaseEvent event) {
        log.trace((Object)("before phase: " + event.getPhaseId()));
        Lifecycle.setPhaseId(event.getPhaseId());
        this.handleTransactionsBeforePhase(event);
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            Lifecycle.beginRequest(event.getFacesContext().getExternalContext());
        } else if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            this.beforeRender(event);
        } else if (event.getPhaseId() == PhaseId.APPLY_REQUEST_VALUES) {
            this.beforeUpdateModelValues(event);
        }
        super.beforePhase(event);
    }

    public void afterPhase(PhaseEvent event) {
        log.trace((Object)("after phase: " + event.getPhaseId()));
        super.afterPhase(event);
        FacesContext facesContext = event.getFacesContext();
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            this.afterRestoreView(facesContext);
        } else if (event.getPhaseId() == PhaseId.INVOKE_APPLICATION) {
            this.afterInvokeApplication();
        }
        FacesMessages.afterPhase();
        this.handleTransactionsAfterPhase(event);
        if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            this.afterRender(facesContext);
        } else if (facesContext.getResponseComplete()) {
            this.afterResponseComplete(facesContext);
        }
        Lifecycle.setPhaseId(null);
    }

    protected void handleTransactionsAfterPhase(PhaseEvent event) {
    }

    protected void handleTransactionsBeforePhase(PhaseEvent event) {
    }
}

