/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.portlet.ActionResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.core.Manager;
import org.jboss.seam.jsf.AbstractSeamPhaseListener;

public class SeamPortletPhaseListener
extends AbstractSeamPhaseListener {
    private static final Log log = LogFactory.getLog(SeamPortletPhaseListener.class);

    public void beforePhase(PhaseEvent event) {
        log.trace((Object)("before phase: " + event.getPhaseId()));
        Lifecycle.setPhaseId(event.getPhaseId());
        this.handleTransactionsBeforePhase(event);
        FacesContext facesContext = event.getFacesContext();
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW || event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            Lifecycle.beginRequest(facesContext.getExternalContext());
        }
        if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            this.afterRestoreView(facesContext);
            this.beforeRender(event);
        } else if (event.getPhaseId() == PhaseId.APPLY_REQUEST_VALUES) {
            this.beforeUpdateModelValues(event);
        }
        super.beforePhase(event);
    }

    public void afterPhase(PhaseEvent event) {
        log.trace((Object)("after phase: " + event.getPhaseId()));
        super.afterPhase(event);
        FacesContext facesContext = event.getFacesContext();
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            this.afterRestoreView(facesContext);
        } else if (event.getPhaseId() == PhaseId.INVOKE_APPLICATION) {
            this.afterInvokeApplication();
        }
        FacesMessages.afterPhase();
        this.handleTransactionsAfterPhase(event);
        if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            this.afterRender(facesContext);
        } else if (event.getPhaseId() == PhaseId.INVOKE_APPLICATION || facesContext.getRenderResponse() || facesContext.getResponseComplete()) {
            Manager.instance().beforeRedirect();
            SeamPortletPhaseListener.writeConversationIdToResponse(facesContext.getExternalContext().getResponse());
            this.afterResponseComplete(facesContext);
        }
        Lifecycle.setPhaseId(null);
    }

    private static void writeConversationIdToResponse(Object response) {
        Manager manager = Manager.instance();
        if (manager.isLongRunningConversation()) {
            SeamPortletPhaseListener.setPortletRenderParameter(response, manager.getConversationIdParameter(), manager.getCurrentConversationId());
            SeamPortletPhaseListener.setPortletRenderParameter(response, manager.getConversationIsLongRunningParameter(), Boolean.toString(manager.isReallyLongRunningConversation()));
        }
    }

    private static void setPortletRenderParameter(Object response, String conversationIdParameter, String conversationId) {
        if (response instanceof ActionResponse) {
            ((ActionResponse)response).setRenderParameter(conversationIdParameter, conversationId);
        }
    }

    protected void handleTransactionsAfterPhase(PhaseEvent event) {
    }

    protected void handleTransactionsBeforePhase(PhaseEvent event) {
    }
}

