/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.core.Init;

public class SeamVariableResolver
extends VariableResolver {
    private static final Log log = LogFactory.getLog(SeamVariableResolver.class);
    private VariableResolver jsfVariableResolver;

    public SeamVariableResolver(VariableResolver jsfVariableResolver) {
        this.jsfVariableResolver = jsfVariableResolver;
    }

    public Object resolveVariable(FacesContext facesContext, String name) throws EvaluationException {
        name = name.replace('$', '.');
        log.debug((Object)("resolving name: " + name));
        Object seamBean = Component.getInstance(name, true);
        if (seamBean == null) {
            Component component = Component.forName(name);
            if (component == null) {
                Object managedBean = this.jsfVariableResolver.resolveVariable(facesContext, name);
                if (managedBean == null) {
                    log.debug((Object)"could not resolve name");
                    return Init.instance().getRootNamespace().getChild(name);
                }
                log.debug((Object)"resolved name to JSF managed bean");
                return managedBean;
            }
            log.debug((Object)"Seam component resolved, but unwrap method returned null");
            return null;
        }
        log.debug((Object)"resolved name to Seam component");
        return seamBean;
    }
}

