/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import org.jboss.seam.mock.MockRenderKit;

public class MockFacesContext
extends FacesContext {
    private UIViewRoot viewRoot;
    private Map<FacesMessage, String> messages = new HashMap<FacesMessage, String>();
    private ExternalContext externalContext;
    private Application application;
    private boolean renderResponse;
    private boolean responseComplete;

    public MockFacesContext(ExternalContext externalContext, Application application) {
        this.externalContext = externalContext;
        this.application = application;
    }

    public Application getApplication() {
        return this.application;
    }

    public Iterator getClientIdsWithMessages() {
        return this.messages.values().iterator();
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public FacesMessage.Severity getMaximumSeverity() {
        FacesMessage.Severity max = null;
        for (FacesMessage msg : this.messages.keySet()) {
            if (max != null && msg.getSeverity().compareTo((Object)max) <= 0) continue;
            max = msg.getSeverity();
        }
        return max;
    }

    public Iterator getMessages() {
        return this.messages.keySet().iterator();
    }

    public Iterator getMessages(String clientId) {
        ArrayList<FacesMessage> list = new ArrayList<FacesMessage>();
        for (Map.Entry<FacesMessage, String> entry : this.messages.entrySet()) {
            if (!clientId.equals(entry.getValue())) continue;
            list.add(entry.getKey());
        }
        return list.iterator();
    }

    public RenderKit getRenderKit() {
        return MockRenderKit.INSTANCE;
    }

    public boolean getRenderResponse() {
        return this.renderResponse;
    }

    public boolean getResponseComplete() {
        return this.responseComplete;
    }

    public ResponseStream getResponseStream() {
        throw new UnsupportedOperationException();
    }

    public void setResponseStream(ResponseStream stream) {
        throw new UnsupportedOperationException();
    }

    public ResponseWriter getResponseWriter() {
        throw new UnsupportedOperationException();
    }

    public void setResponseWriter(ResponseWriter writer) {
        throw new UnsupportedOperationException();
    }

    public UIViewRoot getViewRoot() {
        return this.viewRoot;
    }

    public void setViewRoot(UIViewRoot vr) {
        this.viewRoot = vr;
    }

    public void addMessage(String clientId, FacesMessage msg) {
        this.messages.put(msg, clientId);
    }

    public void release() {
    }

    public void renderResponse() {
        this.renderResponse = true;
    }

    public void responseComplete() {
        this.responseComplete = true;
    }

    public MockFacesContext setCurrent() {
        MockFacesContext.setCurrentInstance((FacesContext)this);
        return this;
    }

    public MockFacesContext createViewRoot() {
        this.viewRoot = new UIViewRoot();
        return this;
    }
}

