/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pageflow;

import java.io.InputStream;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.pageflow.PageflowParser;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.util.ClassLoaderUtil;
import org.xml.sax.InputSource;

public abstract class PageflowHelper {
    static JbpmConfiguration pageflowConfiguration = JbpmConfiguration.parseResource((String)"org/jboss/seam/pageflow/jbpm.pageflow.cfg.xml");
    private static Log log = LogFactory.getLog(PageflowHelper.class);

    public static JbpmContext createPageflowContext() {
        return pageflowConfiguration.createJbpmContext();
    }

    public static ProcessDefinition parseXmlString(String xml) {
        StringReader stringReader = new StringReader(xml);
        return PageflowHelper.parseInputSource(new InputSource(stringReader));
    }

    public static ProcessDefinition parseXmlResource(String xmlResource) {
        InputStream resourceStream = ClassLoaderUtil.getStream((String)xmlResource);
        return PageflowHelper.parseInputSource(new InputSource(resourceStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessDefinition parseInputSource(InputSource inputSource) {
        JbpmContext jbpmContext = PageflowHelper.createPageflowContext();
        try {
            PageflowParser pageflowParser = new PageflowParser(inputSource);
            ProcessDefinition processDefinition = pageflowParser.readProcessDefinition();
            return processDefinition;
        }
        finally {
            jbpmContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signal(ProcessInstance processInstance, String outcome) {
        JbpmContext jbpmContext = PageflowHelper.createPageflowContext();
        try {
            log.debug((Object)("performing pageflow nagivation for outcome " + outcome));
            processInstance.signal(outcome);
        }
        finally {
            jbpmContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessInstance newPageflowInstance(ProcessDefinition processDefinition) {
        JbpmContext jbpmContext = PageflowHelper.createPageflowContext();
        try {
            log.debug((Object)("new pageflow instance for " + processDefinition.getName()));
            ProcessInstance processInstance = processDefinition.createProcessInstance();
            return processInstance;
        }
        finally {
            jbpmContext.close();
        }
    }
}

