/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.remoting.RemotingConfig;
import org.jboss.seam.remoting.RequestHandler;
import org.jboss.seam.remoting.RequestHandlerFactory;
import org.jboss.seam.servlet.SeamServletFilter;

public class SeamRemotingServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(SeamServletFilter.class);
    private static final Pattern pathPattern = Pattern.compile("/(.*?)/([^/]+)");
    private static final String RESOURCE_PATH = "resource";
    private ServletContext servletContext;
    private Map<String, byte[]> cachedConfig = new HashMap<String, byte[]>();

    public void init(ServletConfig config) throws ServletException {
        this.servletContext = config.getServletContext();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            RequestHandler handler = RequestHandlerFactory.getInstance().getRequestHandler(request.getPathInfo());
            if (handler != null) {
                handler.setServletContext(this.servletContext);
                handler.handle(request, response);
            } else {
                Matcher m = pathPattern.matcher(request.getPathInfo());
                if (m.matches()) {
                    String path = m.group(1);
                    String resource = m.group(2);
                    if (RESOURCE_PATH.equals(path)) {
                        this.writeResource(resource, (OutputStream)response.getOutputStream());
                        if ("remote.js".equals(resource)) {
                            this.appendConfig((OutputStream)response.getOutputStream(), request.getContextPath(), request.getSession(), (ServletRequest)request);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error", (Throwable)ex);
        }
    }

    private void appendConfig(OutputStream out, String contextPath, HttpSession session, ServletRequest request) throws IOException {
        if (!this.cachedConfig.containsKey(contextPath)) {
            this.initConfig(contextPath, session, request);
        }
        out.write(this.cachedConfig.get(contextPath));
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initConfig(String contextPath, HttpSession session, ServletRequest request) {
        if (!this.cachedConfig.containsKey(contextPath)) {
            try {
                Lifecycle.beginRequest(this.servletContext, session, request);
                StringBuilder sb = new StringBuilder();
                sb.append("\nSeam.Remoting.contextPath = \"");
                sb.append(contextPath);
                sb.append("\";");
                sb.append("\nSeam.Remoting.debug = ");
                sb.append(RemotingConfig.instance().getDebug() ? "true" : "false");
                sb.append(";");
                sb.append("\nSeam.Remoting.pollInterval = ");
                sb.append(RemotingConfig.instance().getPollInterval());
                sb.append(";");
                sb.append("\nSeam.Remoting.pollTimeout = ");
                sb.append(RemotingConfig.instance().getPollTimeout());
                sb.append(";");
                this.cachedConfig.put(contextPath, sb.toString().getBytes());
            }
            finally {
                Lifecycle.endRequest(session);
            }
        }
    }

    private void writeResource(String resourceName, OutputStream out) throws IOException {
        if (resourceName.endsWith(".js")) {
            InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/jboss/seam/remoting/" + resourceName);
            if (in != null) {
                byte[] buffer = new byte[1024];
                int read = in.read(buffer);
                while (read != -1) {
                    out.write(buffer, 0, read);
                    read = in.read(buffer);
                    out.flush();
                }
            } else {
                log.error((Object)String.format("Resource [%s] not found.", resourceName));
            }
        }
    }
}

