/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.faces.event.PhaseId;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Manager;
import org.jboss.seam.remoting.BaseRequestHandler;
import org.jboss.seam.remoting.RequestHandler;
import org.jboss.seam.remoting.messaging.RemoteSubscriber;
import org.jboss.seam.remoting.messaging.SubscriptionRegistry;
import org.jboss.seam.remoting.messaging.SubscriptionRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionHandler
extends BaseRequestHandler
implements RequestHandler {
    private ServletContext servletContext;

    @Override
    public void setServletContext(ServletContext ctx) {
        this.servletContext = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("text/xml");
        SAXReader xmlReader = new SAXReader();
        Document doc = xmlReader.read((InputStream)request.getInputStream());
        Element env = doc.getRootElement();
        Element body = env.element("body");
        ArrayList<SubscriptionRequest> requests = new ArrayList<SubscriptionRequest>();
        List elements = body.elements("subscribe");
        for (Element e : elements) {
            requests.add(new SubscriptionRequest(e.attributeValue("topic")));
        }
        try {
            HttpSession session = request.getSession(true);
            Lifecycle.setPhaseId(PhaseId.INVOKE_APPLICATION);
            Lifecycle.setServletRequest((ServletRequest)request);
            Lifecycle.beginRequest(this.servletContext, session, (ServletRequest)request);
            Manager.instance().initializeTemporaryConversation();
            Lifecycle.resumeConversation(session);
            for (SubscriptionRequest req : requests) {
                req.subscribe();
            }
            ArrayList<String> unsubscribeTokens = new ArrayList<String>();
            elements = body.elements("unsubscribe");
            for (Element e : elements) {
                unsubscribeTokens.add(e.attributeValue("token"));
            }
            for (String token : unsubscribeTokens) {
                RemoteSubscriber subscriber = SubscriptionRegistry.instance().getSubscription(token);
                if (subscriber == null) continue;
                subscriber.unsubscribe();
            }
        }
        finally {
            Lifecycle.endRequest();
            Lifecycle.setServletRequest(null);
            Lifecycle.setPhaseId(null);
        }
        this.marshalResponse(requests, (OutputStream)response.getOutputStream());
    }

    private void marshalResponse(List<SubscriptionRequest> requests, OutputStream out) throws IOException {
        out.write(ENVELOPE_TAG_OPEN);
        out.write(BODY_TAG_OPEN);
        for (SubscriptionRequest req : requests) {
            req.marshal(out);
        }
        out.write(BODY_TAG_CLOSE);
        out.write(ENVELOPE_TAG_CLOSE);
        out.flush();
    }
}

