/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.io.Serializable;
import java.security.Principal;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.AuthenticationException;
import org.jboss.seam.security.Role;

@Name(value="org.jboss.seam.security.identity")
@Scope(value=ScopeType.SESSION)
@Install(precedence=0, dependencies={"org.jboss.seam.securityManager"})
public abstract class Identity
implements Principal,
Serializable {
    protected boolean authenticated;
    protected boolean valid;

    public static Identity instance() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No active session context");
        }
        Identity instance = (Identity)Component.getInstance(Identity.class, ScopeType.SESSION, true);
        if (instance == null) {
            throw new AuthenticationException("No Identity exists in session scope");
        }
        return instance;
    }

    public abstract Role[] getRoles();

    public abstract Object getCredentials();

    public abstract Object getPrincipal();

    public final boolean isAuthenticated() {
        return this.authenticated;
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final void invalidate() {
        this.valid = false;
    }

    public boolean isUserInRole(String role) {
        for (Role r : this.getRoles()) {
            if (!r.getName().equals(role)) continue;
            return true;
        }
        return false;
    }
}

