/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.security.acl.Permission;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Role
implements Group,
Serializable {
    private String name;
    private Set<Principal> members = new HashSet<Principal>();
    private Set<Permission> permissions = new HashSet<Permission>();

    public Role(String name) {
        this.name = name;
    }

    public boolean addPermission(Permission permission) {
        return this.permissions.add(permission);
    }

    public boolean hasPermission(Permission permission) {
        return this.permissions.contains(permission);
    }

    public boolean removePermission(Permission permission) {
        return this.permissions.remove(permission);
    }

    public boolean addMember(Principal user) {
        return this.members.add(user);
    }

    public boolean isMember(Principal member) {
        if (this.members.contains(member)) {
            return true;
        }
        for (Principal m : this.members) {
            if (!(m instanceof Group) || !((Group)m).isMember(member)) continue;
            return true;
        }
        return false;
    }

    public Enumeration<? extends Principal> members() {
        return Collections.enumeration(this.members);
    }

    public boolean removeMember(Principal user) {
        return this.members.remove(user);
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Role)) {
            return false;
        }
        Role other = (Role)obj;
        return other.name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

