/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.io.InputStreamReader;
import java.io.Reader;
import java.security.acl.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.FactHandle;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.Role;
import org.jboss.seam.security.rules.PermissionCheck;
import org.jboss.seam.util.Resources;

@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.securityManager")
@Install(value=false, precedence=0)
@Intercept(value=InterceptionType.NEVER)
public class SeamSecurityManager {
    private static final String SECURITY_RULES_FILENAME = "/META-INF/security-rules.drl";
    private static final String SECURITY_CONTEXT_NAME = "org.jboss.seam.security.securityContext";
    private RuleBase securityRules;
    private Map<String, Set<Permission>> rolePermissions = new HashMap<String, Set<Permission>>();

    @Create
    public void initSecurityManager() throws Exception {
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration();
        conf.setCompiler(1);
        PackageBuilder builder = new PackageBuilder(conf);
        builder.addPackageFromDrl((Reader)new InputStreamReader(Resources.getResourceAsStream(SECURITY_RULES_FILENAME)));
        this.securityRules = RuleBaseFactory.newRuleBase();
        this.securityRules.addPackage(builder.getPackage());
    }

    public static SeamSecurityManager instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application context");
        }
        SeamSecurityManager instance = (SeamSecurityManager)Component.getInstance(SeamSecurityManager.class, ScopeType.APPLICATION);
        if (instance == null) {
            throw new IllegalStateException("No SeamSecurityManager could be created, make sure the Component exists in application scope");
        }
        return instance;
    }

    public boolean evaluateExpression(String expr) {
        return (Boolean)Expressions.instance().createValueBinding(expr).getValue();
    }

    public static boolean hasRole(String name) {
        return Identity.instance().isUserInRole(name);
    }

    public static boolean hasPermission(String name, String action, Object ... args) {
        SeamSecurityManager mgr = SeamSecurityManager.instance();
        ArrayList<FactHandle> handles = new ArrayList<FactHandle>();
        PermissionCheck check = new PermissionCheck(name, action);
        WorkingMemory wm = mgr.getWorkingMemoryForSession();
        handles.add(wm.assertObject((Object)check));
        for (Object o : args) {
            handles.add(wm.assertObject(o));
        }
        wm.fireAllRules();
        for (FactHandle handle : handles) {
            wm.retractObject(handle);
        }
        return check.isGranted();
    }

    private WorkingMemory getWorkingMemoryForSession() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No active session context found.");
        }
        Context session = Contexts.getSessionContext();
        if (!session.isSet(SECURITY_CONTEXT_NAME)) {
            if (!Identity.instance().isValid()) {
                throw new IllegalStateException("Authenticated Identity is not valid");
            }
            WorkingMemory wm = this.securityRules.newWorkingMemory();
            wm.assertObject((Object)Identity.instance());
            for (Role r : Identity.instance().getRoles()) {
                wm.assertObject((Object)r);
            }
            session.set(SECURITY_CONTEXT_NAME, wm);
            return wm;
        }
        return (WorkingMemory)session.get(SECURITY_CONTEXT_NAME);
    }
}

