/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.acl;

import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Map;
import java.util.Set;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.acl.AclEntryImpl;
import org.jboss.seam.security.acl.AclImpl;
import org.jboss.seam.security.acl.AclProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAclProvider
implements AclProvider {
    @Override
    public Acl getAcls(Object obj) {
        return this.internalGetAcls(obj, null);
    }

    @Override
    public Acl getAcls(Object obj, Principal principal) {
        if (principal == null) {
            throw new IllegalArgumentException("Principal cannot be null");
        }
        return this.internalGetAcls(obj, principal);
    }

    protected Acl internalGetAcls(Object obj, Principal principal) {
        Identity owner = Identity.instance();
        AclImpl acl = new AclImpl(owner);
        AclEntryImpl entry = new AclEntryImpl();
        if (principal != null) {
            entry.setPrincipal(principal);
            for (Permission p : this.getPermissions(obj, principal)) {
                entry.addPermission(p);
            }
        }
        try {
            acl.addEntry(owner, entry);
        }
        catch (NotOwnerException ex) {
            // empty catch block
        }
        return acl;
    }

    protected abstract Set<Permission> getPermissions(Object var1, Principal var2);

    protected abstract Map<Principal, Set<Permission>> getPermissions(Object var1);
}

