/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.acl;

import java.security.Principal;
import java.security.acl.AclEntry;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AclEntryImpl
implements AclEntry {
    private Set<Permission> permissions = new HashSet<Permission>();
    private boolean negative;
    private Principal principal;

    public boolean addPermission(Permission permission) {
        return this.permissions.add(permission);
    }

    public boolean removePermission(Permission permission) {
        return this.permissions.remove(permission);
    }

    public boolean checkPermission(Permission permission) {
        return this.permissions.contains(permission);
    }

    public Enumeration permissions() {
        final Iterator<Permission> iter = this.permissions.iterator();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            public Object nextElement() {
                return iter.next();
            }
        };
    }

    public void setNegativePermissions() {
        this.negative = true;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public boolean setPrincipal(Principal user) {
        if (this.principal != null) {
            return false;
        }
        this.principal = user;
        return true;
    }

    public String toString() {
        String hdr = "AclEntry[";
        StringBuilder sb = new StringBuilder("AclEntry[");
        for (Permission p : this.permissions) {
            if (sb.length() > "AclEntry[".length()) {
                sb.append(',');
            }
            sb.append(p.toString());
        }
        sb.append(']');
        return sb.toString();
    }

    public Object clone() {
        AclEntryImpl clone = new AclEntryImpl();
        for (Permission p : this.permissions) {
            clone.addPermission(p);
        }
        clone.negative = this.negative;
        return clone;
    }
}

