/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.acl;

import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.AclEntry;
import java.security.acl.LastOwnerException;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AclImpl
implements Acl {
    private Set<Principal> owners = new HashSet<Principal>();
    private String name;
    private Map<Principal, AclPair> entries = new HashMap<Principal, AclPair>();

    public AclImpl(Principal owner) {
        this.owners.add(owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEntry(Principal caller, AclEntry entry) throws NotOwnerException {
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        if (!this.entries.containsKey(caller)) {
            Map<Principal, AclPair> map = this.entries;
            synchronized (map) {
                if (!this.entries.containsKey(caller)) {
                    this.entries.put(caller, new AclPair());
                }
            }
        }
        AclPair pair = this.entries.get(caller);
        if (entry.isNegative()) {
            if (pair.hasNegative()) {
                return false;
            }
            pair.setNegative(entry);
        } else {
            if (pair.hasPositive()) {
                return false;
            }
            pair.setPositive(entry);
        }
        return true;
    }

    public boolean checkPermission(Principal principal, Permission permission) {
        AclPair pair = this.entries.get(principal);
        if (pair == null || !pair.hasPositive()) {
            return false;
        }
        return pair.getPositive().checkPermission(permission);
    }

    public Enumeration<AclEntry> entries() {
        ArrayList<AclEntry> allEntries = new ArrayList<AclEntry>();
        for (Principal p : this.entries.keySet()) {
            AclPair pair = this.entries.get(p);
            if (pair.hasPositive()) {
                allEntries.add(pair.getPositive());
            }
            if (!pair.hasNegative()) continue;
            allEntries.add(pair.getNegative());
        }
        final Iterator iter = allEntries.iterator();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            public Object nextElement() {
                return iter.next();
            }
        };
    }

    public Enumeration getPermissions(Principal user) {
        if (!this.entries.containsKey(user)) {
            return new Enumeration(){

                public boolean hasMoreElements() {
                    return false;
                }

                public Object nextElement() {
                    throw new NoSuchElementException();
                }
            };
        }
        return this.entries.get(user).getPositive().permissions();
    }

    public boolean removeEntry(Principal caller, AclEntry entry) throws NotOwnerException {
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        if (!this.entries.containsKey(caller)) {
            return false;
        }
        AclPair pair = this.entries.get(caller);
        if (entry.isNegative() && pair.getNegative().equals(entry)) {
            pair.setNegative(null);
            return true;
        }
        if (!entry.isNegative() && pair.getPositive().equals(entry)) {
            pair.setPositive(null);
            return true;
        }
        return false;
    }

    public void setName(Principal caller, String name) throws NotOwnerException {
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean addOwner(Principal caller, Principal owner) throws NotOwnerException {
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        return this.owners.add(owner);
    }

    public boolean deleteOwner(Principal caller, Principal owner) throws NotOwnerException, LastOwnerException {
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        if (this.owners.contains(owner) && this.owners.size() == 1) {
            throw new LastOwnerException();
        }
        return this.owners.remove(owner);
    }

    public boolean isOwner(Principal owner) {
        return this.owners.contains(owner);
    }

    private class AclPair {
        private AclEntry negative;
        private AclEntry positive;

        private AclPair() {
        }

        public boolean hasNegative() {
            return this.negative != null;
        }

        public boolean hasPositive() {
            return this.positive != null;
        }

        public AclEntry getNegative() {
            return this.negative;
        }

        public void setNegative(AclEntry value) {
            this.negative = value;
            this.checkDuplicates();
        }

        public AclEntry getPositive() {
            return this.positive;
        }

        public void setPositive(AclEntry value) {
            this.positive = value;
            this.checkDuplicates();
        }

        private void checkDuplicates() {
            if (this.negative != null && this.positive != null) {
                HashSet<Permission> dupes = new HashSet<Permission>();
                Enumeration e = this.negative.permissions();
                block0: while (e.hasMoreElements()) {
                    Permission neg = (Permission)e.nextElement();
                    Enumeration e2 = this.positive.permissions();
                    while (e2.hasMoreElements()) {
                        Permission pos = (Permission)e2.nextElement();
                        if (!neg.equals(pos)) continue;
                        dupes.add(pos);
                        continue block0;
                    }
                }
                for (Permission dupe : dupes) {
                    this.negative.removePermission(dupe);
                    this.positive.removePermission(dupe);
                }
            }
        }
    }
}

