/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.acl;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Id;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.security.acl.IdentityException;
import org.jboss.seam.security.acl.IdentityGenerator;

public class JPAIdentityGenerator
implements IdentityGenerator {
    private Map<Class, IdentityMetadata> identityMeta = new HashMap<Class, IdentityMetadata>();

    public String generateIdentity(Object obj) {
        IdentityMetadata meta = this.getIdentityMetadata(obj.getClass());
        Object val = meta.getIdentityValue(obj);
        return val == null ? null : String.format("%s:%s", meta.name, val.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IdentityMetadata getIdentityMetadata(Class cls) {
        if (!this.identityMeta.containsKey(cls)) {
            Map<Class, IdentityMetadata> map = this.identityMeta;
            synchronized (map) {
                if (!this.identityMeta.containsKey(cls)) {
                    IdentityMetadata meta = new IdentityMetadata();
                    for (Method method : cls.getMethods()) {
                        if (!method.isAnnotationPresent(Id.class)) continue;
                        if (method.getParameterTypes().length > 0) {
                            throw new IllegalArgumentException(String.format("Specified class [%s] has illegal identifier method - must accept no parameters.", cls.getName()));
                        }
                        meta.idType = IdentityType.method;
                        meta.identityMethod = method;
                        method.setAccessible(true);
                        break;
                    }
                    if (meta.identityMethod == null) {
                        for (AccessibleObject accessibleObject : cls.getDeclaredFields()) {
                            System.out.println("Field: " + ((Field)accessibleObject).getName());
                            if (!accessibleObject.isAnnotationPresent(Id.class)) continue;
                            meta.idType = IdentityType.field;
                            meta.identityField = accessibleObject;
                            ((Field)accessibleObject).setAccessible(true);
                            break;
                        }
                    }
                    if (meta.identityField == null && meta.identityMethod == null) {
                        throw new IllegalArgumentException(String.format("Specified class [%s] has no identifier method or field.", cls.getName()));
                    }
                    meta.name = cls.isAnnotationPresent(Name.class) ? cls.getAnnotation(Name.class).value() : cls.getName();
                    this.identityMeta.put(cls, meta);
                }
            }
        }
        return this.identityMeta.get(cls);
    }

    private class IdentityMetadata {
        IdentityType idType;
        String name;
        Field identityField;
        Method identityMethod;

        private IdentityMetadata() {
        }

        public Object getIdentityValue(Object obj) {
            switch (this.idType) {
                case field: {
                    try {
                        return this.identityField.get(obj);
                    }
                    catch (IllegalAccessException ex) {
                        throw new IdentityException(String.format("IllegalAccessException reading identifier field on object [%s]", obj), ex);
                    }
                }
                case method: {
                    try {
                        return this.identityMethod.invoke(obj, new Object[0]);
                    }
                    catch (IllegalAccessException ex) {
                        throw new IdentityException(String.format("IllegalAccessException invoking identifier method on object [%s]", obj), ex);
                    }
                    catch (InvocationTargetException ex) {
                        throw new IdentityException(String.format("InvocationTargetException invoking identifier method on object [%s]", obj), ex);
                    }
                }
            }
            throw new IllegalStateException("Invalid identifier type");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum IdentityType {
        field,
        method;

    }
}

