/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.acl;

import java.security.Principal;
import java.security.acl.Permission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.ManagedHibernateSession;
import org.jboss.seam.core.ManagedPersistenceContext;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.Role;
import org.jboss.seam.security.acl.AbstractAclProvider;
import org.jboss.seam.security.acl.AclProvider;
import org.jboss.seam.util.Naming;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Intercept(value=InterceptionType.NEVER)
@Scope(value=ScopeType.APPLICATION)
public class PersistentAclProvider
extends AbstractAclProvider {
    protected PersistenceType persistenceType;
    private Object pcm;
    private String aclQuery;

    public Object getPersistenceContextManager() {
        return this.pcm;
    }

    public void setPersistenceContextManager(Object value) {
        if (ManagedPersistenceContext.class.isAssignableFrom(value.getClass())) {
            this.persistenceType = PersistenceType.managedPersistenceContext;
            this.pcm = value;
        } else if (ManagedHibernateSession.class.isAssignableFrom(value.getClass())) {
            this.persistenceType = PersistenceType.managedHibernateSession;
            this.pcm = value;
        } else if (EntityManagerFactory.class.isAssignableFrom(value.getClass())) {
            this.persistenceType = PersistenceType.entityManagerFactory;
            this.pcm = value;
        } else {
            if (value instanceof String) {
                Object obj = null;
                try {
                    obj = Naming.getInitialContext().lookup((String)value);
                    if (EntityManagerFactory.class.isAssignableFrom(obj.getClass())) {
                        this.persistenceType = PersistenceType.entityManagerFactory;
                        this.pcm = obj;
                        return;
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                throw new IllegalArgumentException("Invalid JNDI name specified for EntityManagerFactory");
            }
            throw new IllegalArgumentException("Parameter must be instance of ManagedPersistenceContext, ManagedHibernateSession or String value specifying the JNDI name of an EntityManagerFactory");
        }
    }

    public String getAclQuery() {
        return this.aclQuery;
    }

    public void setAclQuery(String aclQuery) {
        this.aclQuery = aclQuery;
    }

    protected Object createAclQuery() throws Exception {
        switch (this.persistenceType) {
            case managedPersistenceContext: {
                return ((ManagedPersistenceContext)this.pcm).getEntityManager().createQuery(this.aclQuery);
            }
            case managedHibernateSession: {
                return ((ManagedHibernateSession)this.pcm).getSession().createQuery(this.aclQuery);
            }
            case entityManagerFactory: {
                EntityManager em = ((EntityManagerFactory)this.pcm).createEntityManager();
                return em.createQuery(this.aclQuery);
            }
        }
        throw new IllegalStateException("Unknown persistence type");
    }

    protected void bindQueryParams(Object query, Object target, Principal principal) {
        ArrayList<Role> roles = new ArrayList<Role>();
        if (Identity.class.isAssignableFrom(principal.getClass())) {
            for (Role role : ((Identity)principal).getRoles()) {
                roles.add(role);
            }
        }
    }

    protected Object executeQuery(Object query) {
        switch (this.persistenceType) {
            case managedPersistenceContext: 
            case entityManagerFactory: {
                return ((Query)query).getResultList();
            }
            case managedHibernateSession: {
                return ((org.hibernate.Query)query).list();
            }
        }
        return null;
    }

    protected Set<Permission> convertToPermissions(Principal principal, Object target, Object perms) {
        if (perms == null) {
            return null;
        }
        if (List.class.isAssignableFrom(perms.getClass())) {
            HashSet<Permission> permissions = new HashSet<Permission>();
            for (Object o : (List)perms) {
                if (!(o instanceof Object[])) continue;
                Object[] values = (Object[])o;
                int mask = (Integer)values[0];
                String recipient = (String)values[1];
                AclProvider.RecipientType recipientType = (AclProvider.RecipientType)((Object)values[2]);
            }
            return permissions;
        }
        throw new IllegalArgumentException(String.format("Permissions [%s] must be an instance of java.util.List", perms));
    }

    @Override
    public Set<Permission> getPermissions(Object obj, Principal principal) {
        try {
            Object q = this.createAclQuery();
            this.bindQueryParams(q, obj, principal);
            Object result = this.executeQuery(q);
            return this.convertToPermissions(principal, obj, result);
        }
        catch (Exception ex) {
            throw new SecurityException(String.format("Error determining permissions: %s", ex.getMessage()), ex);
        }
    }

    @Override
    public Map<Principal, Set<Permission>> getPermissions(Object obj) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PersistenceType {
        managedPersistenceContext,
        managedHibernateSession,
        entityManagerFactory;

    }
}

