/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.authenticator;

import java.util.ArrayList;
import java.util.List;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.security.AuthenticationException;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.authenticator.Authenticator;
import org.jboss.seam.security.provider.AuthenticationProvider;
import org.jboss.seam.util.Reflections;

@Name(value="org.jboss.seam.security.authenticator")
@Scope(value=ScopeType.APPLICATION)
@Install(value=false, precedence=0)
public class ProviderAuthenticator
extends Authenticator {
    private List<Object> providers = new ArrayList<Object>();

    public Identity doAuthentication(Identity authentication) throws AuthenticationException {
        for (Object p : this.providers) {
            Identity result;
            AuthenticationProvider provider = null;
            if (p instanceof AuthenticationProvider) {
                provider = (AuthenticationProvider)p;
            } else if (p instanceof Component) {
                provider = (AuthenticationProvider)((Component)p).newInstance();
            }
            if ((result = provider.authenticate(authentication)) == null) continue;
            return result;
        }
        throw new AuthenticationException("Provider not found");
    }

    public void setProviders(Object values) {
        if (values instanceof AuthenticationProvider) {
            this.providers.add(values);
        } else {
            for (Object provider : (List)values) {
                if (provider instanceof Component) {
                    this.providers.add(provider);
                    continue;
                }
                try {
                    provider = Reflections.classForName(provider.toString()).newInstance();
                    this.providers.add(provider);
                }
                catch (Exception ex) {}
            }
        }
    }
}

