/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.config;

import java.io.InputStream;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.security.Role;
import org.jboss.seam.security.SeamPermission;
import org.jboss.seam.security.config.SecurityConfigException;
import org.jboss.seam.util.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.security.securityConfiguration")
@Install(value=false, precedence=0, dependencies={"org.jboss.seam.securityManager"})
@Intercept(value=InterceptionType.NEVER)
public class SecurityConfiguration {
    private static final String SECURITY_CONFIG_FILENAME = "/META-INF/security-config.xml";
    private static final String SECURITY_ROLES = "roles";
    private static final String SECURITY_ROLE = "role";
    private static final String SECURITY_MEMBERS = "members";
    private static final String SECURITY_PERMISSIONS = "permissions";
    private static final String SECURITY_PERMISSION = "permission";
    private Map<String, Role> securityRoles = new HashMap<String, Role>();

    @Create
    public void init() throws SecurityConfigException {
        this.loadConfigFromStream(Resources.getResourceAsStream(SECURITY_CONFIG_FILENAME));
    }

    protected void loadConfigFromStream(InputStream config) throws SecurityConfigException {
        try {
            SAXReader xmlReader = new SAXReader();
            Document doc = xmlReader.read(config);
            Element env = doc.getRootElement();
            this.loadSecurityRoles(env.element(SECURITY_ROLES));
        }
        catch (Exception ex) {
            if (ex instanceof SecurityConfigException) {
                throw (SecurityConfigException)ex;
            }
            throw new SecurityConfigException("Error loading security configuration", ex);
        }
    }

    public Set<Role> getSecurityRoles() {
        return new HashSet<Role>(this.securityRoles.values());
    }

    protected void loadSecurityRoles(Element securityRoleElement) throws SecurityConfigException {
        Role r;
        HashMap members = new HashMap();
        for (Element role : securityRoleElement.elements(SECURITY_ROLE)) {
            Element permissionsElement;
            r = new Role(role.attributeValue("name"));
            HashSet<String> mbrs = new HashSet<String>();
            members.put(r.getName(), mbrs);
            Element m = role.element(SECURITY_MEMBERS);
            if (m != null) {
                for (String member : m.getTextTrim().split("[,]")) {
                    mbrs.add(member);
                }
            }
            if ((permissionsElement = role.element(SECURITY_PERMISSIONS)) != null) {
                for (Element permission : permissionsElement.elements(SECURITY_PERMISSION)) {
                    r.addPermission(new SeamPermission(permission.attributeValue("name"), permission.attributeValue("action")));
                }
            }
            this.securityRoles.put(r.getName(), r);
        }
        for (String roleName : members.keySet()) {
            r = this.securityRoles.get(roleName);
            for (String member : (Set)members.get(roleName)) {
                r.addMember((Principal)((Object)this.securityRoles.get(member)));
            }
        }
    }
}

