/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.servlet;

import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.Pages;

public class SeamRedirectFilter
implements Filter {
    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, SeamRedirectFilter.wrapResponse((HttpServletResponse)response));
    }

    private static ServletResponse wrapResponse(HttpServletResponse response) {
        return new HttpServletResponseWrapper(response){

            public void sendRedirect(String url) throws IOException {
                if (Contexts.isEventContextActive()) {
                    String viewId = SeamRedirectFilter.getViewId(url);
                    if (viewId != null) {
                        url = Pages.instance().encodePageParameters(FacesContext.getCurrentInstance(), url, viewId);
                    }
                    url = Manager.instance().appendConversationIdFromRedirectFilter(url);
                }
                super.sendRedirect(url);
            }
        };
    }

    public void destroy() {
    }

    public static String getViewId(String url) {
        String pathInfo = FacesContext.getCurrentInstance().getExternalContext().getRequestPathInfo();
        String servletPath = FacesContext.getCurrentInstance().getExternalContext().getRequestServletPath();
        String contextPath = FacesContext.getCurrentInstance().getExternalContext().getRequestContextPath();
        if (pathInfo != null) {
            return url.substring(contextPath.length() + servletPath.length(), SeamRedirectFilter.getParamLoc(url));
        }
        if (url.startsWith(contextPath)) {
            String extension = servletPath.substring(servletPath.lastIndexOf(46));
            if (url.endsWith(extension) || url.contains(extension + '?')) {
                String suffix = Pages.getSuffix();
                return url.substring(contextPath.length(), SeamRedirectFilter.getParamLoc(url) - extension.length()) + suffix;
            }
            return null;
        }
        return null;
    }

    private static int getParamLoc(String url) {
        int loc = url.indexOf(63);
        if (loc < 0) {
            loc = url.length();
        }
        return loc;
    }
}

