/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.theme;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.AbstractMutable;
import org.jboss.seam.core.Locale;
import org.jboss.seam.theme.Theme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.SESSION)
@Name(value="org.jboss.seam.theme.themeSelector")
@Intercept(value=InterceptionType.NEVER)
@Install(precedence=0)
public class ThemeSelector
extends AbstractMutable
implements Serializable {
    private static final Log log = LogFactory.getLog(ThemeSelector.class);
    private String theme;
    private String[] availableThemes;
    private boolean cookieEnabled;
    private int cookieMaxAge = 31536000;

    @Create
    public void initDefaultTheme() {
        Cookie cookie;
        if (this.cookieEnabled && (cookie = (Cookie)FacesContext.getCurrentInstance().getExternalContext().getRequestCookieMap().get("org.jboss.seam.core.Theme")) != null) {
            this.theme = cookie.getValue();
        }
        if (this.theme == null) {
            if (this.availableThemes.length == 0) {
                throw new IllegalStateException("no themes defined");
            }
            if (this.theme == null) {
                this.theme = this.availableThemes[0];
            }
        }
    }

    public void select() {
        Contexts.removeFromAllContexts(Seam.getComponentName(Theme.class));
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String viewId = facesContext.getViewRoot().getViewId();
        UIViewRoot viewRoot = facesContext.getApplication().getViewHandler().createView(facesContext, viewId);
        facesContext.setViewRoot(viewRoot);
        if (this.cookieEnabled) {
            HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
            Cookie cookie = new Cookie("org.jboss.seam.core.Theme", this.theme);
            cookie.setMaxAge(this.cookieMaxAge);
            response.addCookie(cookie);
        }
    }

    public List<SelectItem> getThemes() {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>(this.availableThemes.length);
        for (String name : this.availableThemes) {
            selectItems.add(new SelectItem((Object)name, name));
        }
        return selectItems;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String themeName) {
        this.setDirty(this.theme, themeName);
        this.theme = themeName;
    }

    public void setAvailableThemes(String[] themeNames) {
        this.setDirty(this.availableThemes, themeNames);
        this.availableThemes = themeNames;
    }

    public ResourceBundle getThemeResourceBundle() {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.theme, Locale.instance(), Thread.currentThread().getContextClassLoader());
            log.debug((Object)("loaded resource bundle: " + this.theme));
            return bundle;
        }
        catch (MissingResourceException mre) {
            log.debug((Object)("resource bundle missing: " + this.theme));
            return null;
        }
    }

    public static ThemeSelector instance() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No active session context");
        }
        return (ThemeSelector)Component.getInstance(ThemeSelector.class, ScopeType.SESSION);
    }

    public String[] getAvailableThemes() {
        return this.availableThemes;
    }

    public boolean isCookieEnabled() {
        return this.cookieEnabled;
    }

    public void setCookieEnabled(boolean cookieEnabled) {
        this.setDirty(this.cookieEnabled, cookieEnabled);
        this.cookieEnabled = cookieEnabled;
    }

    protected int getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    protected void setCookieMaxAge(int cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }
}

