/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.util;

import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.util.Transactions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Work<T> {
    private static final Log log = LogFactory.getLog(Work.class);

    protected abstract T work() throws Exception;

    protected boolean isTransactional() {
        return true;
    }

    public final T workInTransaction() throws Exception {
        UserTransaction userTransaction;
        boolean begin = this.isTransactional() && !Transactions.isTransactionActiveOrMarkedRollback();
        Object object = userTransaction = begin ? Transactions.getUserTransaction() : null;
        if (begin) {
            log.debug((Object)"beginning transaction");
            userTransaction.begin();
        }
        try {
            T result = this.work();
            if (begin) {
                log.debug((Object)"committing transaction");
                userTransaction.commit();
            }
            return result;
        }
        catch (Exception e) {
            if (begin) {
                log.debug((Object)"rolling back transaction");
                userTransaction.rollback();
            }
            throw e;
        }
    }
}

