/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.servlet.http.HttpSessionActivationListener;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import org.hibernate.validator.ClassValidator;
import org.jboss.seam.ComponentType;
import org.jboss.seam.InstantiationException;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.InterceptorType;
import org.jboss.seam.Namespace;
import org.jboss.seam.RequiredException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Asynchronous;
import org.jboss.seam.annotations.Conversational;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.DataBinderClass;
import org.jboss.seam.annotations.DataSelectorClass;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.IfInvalid;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Interceptors;
import org.jboss.seam.annotations.JndiName;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.RaiseEvent;
import org.jboss.seam.annotations.RequestParameter;
import org.jboss.seam.annotations.Rollback;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.Synchronized;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Mutable;
import org.jboss.seam.core.ResourceBundle;
import org.jboss.seam.databinding.DataBinder;
import org.jboss.seam.databinding.DataSelector;
import org.jboss.seam.ejb.SeamInterceptor;
import org.jboss.seam.intercept.ClientSideInterceptor;
import org.jboss.seam.intercept.Interceptor;
import org.jboss.seam.intercept.JavaBeanInterceptor;
import org.jboss.seam.intercept.Proxy;
import org.jboss.seam.interceptors.AsynchronousInterceptor;
import org.jboss.seam.interceptors.BijectionInterceptor;
import org.jboss.seam.interceptors.BusinessProcessInterceptor;
import org.jboss.seam.interceptors.ConversationInterceptor;
import org.jboss.seam.interceptors.ConversationalInterceptor;
import org.jboss.seam.interceptors.EventInterceptor;
import org.jboss.seam.interceptors.ManagedEntityIdentityInterceptor;
import org.jboss.seam.interceptors.MethodContextInterceptor;
import org.jboss.seam.interceptors.OutcomeInterceptor;
import org.jboss.seam.interceptors.RemoveInterceptor;
import org.jboss.seam.interceptors.RollbackInterceptor;
import org.jboss.seam.interceptors.SecurityInterceptor;
import org.jboss.seam.interceptors.SynchronizationInterceptor;
import org.jboss.seam.interceptors.TransactionInterceptor;
import org.jboss.seam.interceptors.ValidationInterceptor;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Conversions;
import org.jboss.seam.util.EJB;
import org.jboss.seam.util.Naming;
import org.jboss.seam.util.Parameters;
import org.jboss.seam.util.Reflections;
import org.jboss.seam.util.SortItem;
import org.jboss.seam.util.SorterNew;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
public class Component {
    public static final String PROPERTIES = "org.jboss.seam.properties";
    private static final LogProvider log = Logging.getLogProvider(Component.class);
    private ComponentType type;
    private String name;
    private ScopeType scope;
    private Class<?> beanClass;
    private String jndiName;
    private InterceptionType interceptionType;
    private boolean startup;
    private String[] dependencies;
    private boolean synchronize;
    private long timeout;
    private Method destroyMethod;
    private Method createMethod;
    private Method unwrapMethod;
    private Method preDestroyMethod;
    private Method postConstructMethod;
    private Method prePassivateMethod;
    private Method postActivateMethod;
    private Map<String, Method> removeMethods = new HashMap<String, Method>();
    private Set<Method> validateMethods = new HashSet<Method>();
    private Set<Method> inMethods = new HashSet<Method>();
    private Set<Field> inFields = new HashSet<Field>();
    private Set<Method> outMethods = new HashSet<Method>();
    private Set<Field> outFields = new HashSet<Field>();
    private Set<Field> parameterFields = new HashSet<Field>();
    private Set<Method> parameterSetters = new HashSet<Method>();
    private Map<Method, InitialValue> initializerSetters = new HashMap<Method, InitialValue>();
    private Map<Field, InitialValue> initializerFields = new HashMap<Field, InitialValue>();
    private List<Method> dataModelGetters = new ArrayList<Method>();
    private Map<Method, Annotation> dataModelGetterAnnotations = new HashMap<Method, Annotation>();
    private Map<String, Method> dataModelSelectionSetters = new HashMap<String, Method>();
    private Map<Method, Annotation> dataModelSelectionSetterAnnotations = new HashMap<Method, Annotation>();
    private List<Field> dataModelFields = new ArrayList<Field>();
    private Map<Field, Annotation> dataModelFieldAnnotations = new HashMap<Field, Annotation>();
    private Map<String, Field> dataModelSelectionFields = new HashMap<String, Field>();
    private Map<Field, Annotation> dataModelSelectionFieldAnnotations = new HashMap<Field, Annotation>();
    private List<Field> logFields = new ArrayList<Field>();
    private List<Log> logInstances = new ArrayList<Log>();
    private Hashtable<Locale, ClassValidator> validators = new Hashtable();
    private List<Interceptor> interceptors = new ArrayList<Interceptor>();
    private List<Interceptor> clientSideInterceptors = new ArrayList<Interceptor>();
    private Set<Class> businessInterfaces;
    private Class<net.sf.cglib.proxy.Factory> factory;

    public Component(Class<?> clazz) {
        this(clazz, Seam.getComponentName(clazz));
    }

    public Component(Class<?> clazz, String componentName) {
        this(clazz, componentName, Seam.getComponentScope(clazz), null);
    }

    public Component(Class<?> clazz, Context applicationContext) {
        this(clazz, Seam.getComponentName(clazz), Seam.getComponentScope(clazz), null, applicationContext);
    }

    public Component(Class<?> clazz, String componentName, ScopeType componentScope, String jndiName) {
        this(clazz, componentName, componentScope, jndiName, Contexts.getApplicationContext());
    }

    private Component(Class<?> clazz, String componentName, ScopeType componentScope, String componentJndiName, Context applicationContext) {
        this.beanClass = clazz;
        this.name = componentName;
        this.scope = componentScope;
        this.type = Seam.getComponentType(this.beanClass);
        this.interceptionType = Seam.getInterceptionType(this.beanClass);
        this.initNamespaces(componentName, applicationContext);
        this.checkScopeForComponentType();
        this.jndiName = componentJndiName == null ? this.getJndiName(applicationContext) : componentJndiName;
        this.startup = this.beanClass.isAnnotationPresent(Startup.class);
        if (this.startup) {
            if (this.scope != ScopeType.SESSION && this.scope != ScopeType.APPLICATION) {
                throw new IllegalArgumentException("@Startup only supported for SESSION or APPLICATION scoped components: " + this.name);
            }
            this.dependencies = this.getBeanClass().getAnnotation(Startup.class).depends();
        }
        boolean bl = this.synchronize = this.scope == ScopeType.SESSION || this.beanClass.isAnnotationPresent(Synchronized.class);
        if (this.synchronize) {
            if (this.scope == ScopeType.STATELESS) {
                throw new IllegalArgumentException("@Synchronized not meaningful for stateless components: " + this.name);
            }
            this.timeout = this.beanClass.isAnnotationPresent(Synchronized.class) ? this.beanClass.getAnnotation(Synchronized.class).timeout() : 1000L;
        }
        log.info("Component: " + this.getName() + ", scope: " + (Object)((Object)this.getScope()) + ", type: " + (Object)((Object)this.getType()) + ", class: " + this.beanClass.getName() + (this.jndiName == null ? "" : ", JNDI: " + this.jndiName));
        this.initMembers(clazz, applicationContext);
        this.checkDestroyMethod();
        this.businessInterfaces = Component.getBusinessInterfaces(this.beanClass);
        if (this.interceptionType != InterceptionType.NEVER) {
            this.initInterceptors();
        }
        this.initInitializers(applicationContext);
    }

    private void initNamespaces(String componentName, Context applicationContext) {
        Init init;
        if (applicationContext != null && (init = (Init)applicationContext.get(Seam.getComponentName(Init.class))) != null) {
            Namespace namespace = init.getRootNamespace();
            StringTokenizer tokens = new StringTokenizer(componentName, ".");
            StringBuffer path = new StringBuffer();
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                path.append(token).append('.');
                if (tokens.hasMoreTokens() && !namespace.hasChild(token)) {
                    namespace.addChild(token, new Namespace(path.toString()));
                }
                namespace = namespace.getChild(token);
            }
        }
    }

    private void checkScopeForComponentType() {
        boolean serializableType;
        if (this.scope == ScopeType.STATELESS && (this.type == ComponentType.STATEFUL_SESSION_BEAN || this.type == ComponentType.ENTITY_BEAN)) {
            throw new IllegalArgumentException("Only stateless session beans and Java beans may be bound to the STATELESS context: " + this.name);
        }
        if (this.scope == ScopeType.PAGE && this.type == ComponentType.STATEFUL_SESSION_BEAN) {
            throw new IllegalArgumentException("Stateful session beans may not be bound to the PAGE context: " + this.name);
        }
        if (this.scope == ScopeType.APPLICATION && this.type == ComponentType.STATEFUL_SESSION_BEAN) {
            log.warn("Stateful session beans was bound to the APPLICATION context - note that it is not safe to make concurrent calls to the bean: " + this.name);
        }
        if (this.scope != ScopeType.STATELESS && this.type == ComponentType.MESSAGE_DRIVEN_BEAN) {
            throw new IllegalArgumentException("Message-driven beans must be bound to STATELESS context: " + this.name);
        }
        boolean serializableScope = this.scope == ScopeType.PAGE || this.scope == ScopeType.SESSION || this.scope == ScopeType.CONVERSATION;
        boolean bl = serializableType = this.type == ComponentType.JAVA_BEAN || this.type == ComponentType.ENTITY_BEAN;
        if (serializableType && serializableScope && !Serializable.class.isAssignableFrom(this.beanClass)) {
            log.warn("Component class should be serializable: " + this.name);
        }
    }

    private void checkDestroyMethod() {
        if (!(this.type != ComponentType.STATEFUL_SESSION_BEAN || this.destroyMethod != null && this.removeMethods.values().contains(this.destroyMethod))) {
            throw new IllegalArgumentException("Stateful session bean component should have a method marked @Remove @Destroy: " + this.name);
        }
    }

    private String getJndiName(Context applicationContext) {
        if (this.beanClass.isAnnotationPresent(JndiName.class)) {
            return this.beanClass.getAnnotation(JndiName.class).value();
        }
        switch (this.type) {
            case ENTITY_BEAN: 
            case JAVA_BEAN: {
                return null;
            }
        }
        if (applicationContext == null) {
            return null;
        }
        String jndiPattern = Init.instance().getJndiPattern();
        if (jndiPattern == null) {
            throw new IllegalArgumentException("You must specify org.jboss.seam.core.init.jndiPattern or use @JndiName: " + this.name);
        }
        return jndiPattern.replace("#{ejbName}", Seam.getEjbName(this.beanClass));
    }

    private void initInitializers(Context applicationContext) {
        if (applicationContext == null) {
            return;
        }
        Map properties = (Map)applicationContext.get(PROPERTIES);
        if (properties == null) {
            return;
        }
        for (Map.Entry me : properties.entrySet()) {
            String propertyName;
            Method setterMethod;
            String key = (String)me.getKey();
            Conversions.PropertyValue propertyValue = (Conversions.PropertyValue)me.getValue();
            if (!key.startsWith(this.name) || key.charAt(this.name.length()) != '.') continue;
            if (log.isDebugEnabled()) {
                log.debug(key + "=" + propertyValue);
            }
            if ((setterMethod = Reflections.getSetterMethod(this.beanClass, propertyName = key.substring(this.name.length() + 1, key.length()))) != null) {
                if (!setterMethod.isAccessible()) {
                    setterMethod.setAccessible(true);
                }
                Class<?> parameterClass = setterMethod.getParameterTypes()[0];
                Type parameterType = setterMethod.getGenericParameterTypes()[0];
                this.initializerSetters.put(setterMethod, this.getTopInitialValue(propertyValue, parameterClass, parameterType));
                continue;
            }
            Field field = Reflections.getField(this.beanClass, propertyName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            this.initializerFields.put(field, Component.getInitialValue(propertyValue, field.getType(), field.getGenericType()));
        }
    }

    private InitialValue getTopInitialValue(Conversions.PropertyValue propertyValue, Class parameterClass, Type parameterType) {
        if (propertyValue.isExpression() && this.getBeanClass().equals(Init.class)) {
            return new ConstantInitialValue(propertyValue, parameterClass, parameterType);
        }
        return Component.getInitialValue(propertyValue, parameterClass, parameterType);
    }

    private static InitialValue getInitialValue(Conversions.PropertyValue propertyValue, Class parameterClass, Type parameterType) {
        if (propertyValue.isExpression()) {
            return new ELInitialValue(propertyValue, parameterClass, parameterType);
        }
        if (propertyValue.isMultiValued()) {
            return new ListInitialValue(propertyValue, parameterClass, parameterType);
        }
        if (propertyValue.isAssociativeValued()) {
            return new MapInitialValue(propertyValue, parameterClass, parameterType);
        }
        return new ConstantInitialValue(propertyValue, parameterClass, parameterType);
    }

    private void initMembers(Class<?> clazz, Context applicationContext) {
        Annotation ann;
        ArrayList<Method> selectionSetters = new ArrayList<Method>();
        ArrayList<AccessibleObject> selectionFields = new ArrayList<AccessibleObject>();
        while (clazz != Object.class) {
            for (Method method : clazz.getDeclaredMethods()) {
                Init init;
                if (method.isAnnotationPresent(IfInvalid.class)) {
                    this.validateMethods.add(method);
                }
                if (method.isAnnotationPresent(EJB.REMOVE)) {
                    this.removeMethods.put(method.getName(), method);
                }
                if (method.isAnnotationPresent(Destroy.class)) {
                    if (this.type != ComponentType.JAVA_BEAN && this.type != ComponentType.STATEFUL_SESSION_BEAN) {
                        throw new IllegalArgumentException("Only JavaBeans and stateful session beans support @Destroy methods: " + this.name);
                    }
                    if (this.destroyMethod != null) {
                        throw new IllegalStateException("component has two @Destroy methods: " + this.name);
                    }
                    this.destroyMethod = method;
                }
                if (method.isAnnotationPresent(Create.class)) {
                    if (this.type != ComponentType.JAVA_BEAN && this.type != ComponentType.STATEFUL_SESSION_BEAN) {
                        throw new IllegalArgumentException("Only JavaBeans and stateful session beans support @Create methods: " + this.name);
                    }
                    if (this.createMethod != null) {
                        throw new IllegalStateException("component has two @Create methods: " + this.name);
                    }
                    this.createMethod = method;
                }
                if (method.isAnnotationPresent(In.class)) {
                    this.inMethods.add(method);
                }
                if (method.isAnnotationPresent(Out.class)) {
                    this.outMethods.add(method);
                }
                if (method.isAnnotationPresent(Unwrap.class)) {
                    if (this.unwrapMethod != null) {
                        throw new IllegalStateException("component has two @Unwrap methods: " + this.name);
                    }
                    this.unwrapMethod = method;
                }
                if (method.isAnnotationPresent(DataModel.class)) {
                    this.checkDataModelScope(method.getAnnotation(DataModel.class));
                }
                if (method.isAnnotationPresent(Factory.class)) {
                    init = (Init)applicationContext.get(Seam.getComponentName(Init.class));
                    String contextVariable = Component.toName(method.getAnnotation(Factory.class).value(), method);
                    init.addFactoryMethod(contextVariable, method, this);
                }
                if (method.isAnnotationPresent(Observer.class)) {
                    init = (Init)applicationContext.get(Seam.getComponentName(Init.class));
                    Observer observer = method.getAnnotation(Observer.class);
                    for (String eventType : observer.value()) {
                        if (eventType.length() == 0) {
                            eventType = method.getName();
                        }
                        init.addObserverMethod(eventType, method, this, observer.create());
                    }
                }
                if (method.isAnnotationPresent(RequestParameter.class)) {
                    this.parameterSetters.add(method);
                }
                if (method.isAnnotationPresent(EJB.PRE_PASSIVATE)) {
                    this.prePassivateMethod = method;
                }
                if (method.isAnnotationPresent(EJB.POST_ACTIVATE)) {
                    this.postActivateMethod = method;
                }
                if (method.isAnnotationPresent(EJB.POST_CONSTRUCT)) {
                    this.postConstructMethod = method;
                }
                if (method.isAnnotationPresent(EJB.PRE_DESTROY)) {
                    this.preDestroyMethod = method;
                }
                if (method.isAnnotationPresent(EJB.PERSISTENCE_CONTEXT) && !this.type.isSessionBean() && this.type != ComponentType.MESSAGE_DRIVEN_BEAN) {
                    throw new IllegalArgumentException("@PersistenceContext may only be used on session bean or message driven bean components: " + this.name);
                }
                for (Annotation ann2 : method.getAnnotations()) {
                    if (ann2.annotationType().isAnnotationPresent(DataBinderClass.class)) {
                        this.dataModelGetters.add(method);
                        this.dataModelGetterAnnotations.put(method, ann2);
                    }
                    if (!ann2.annotationType().isAnnotationPresent(DataSelectorClass.class)) continue;
                    selectionSetters.add(method);
                    this.dataModelSelectionSetterAnnotations.put(method, ann2);
                }
                if (method.isAccessible()) continue;
                method.setAccessible(true);
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                if (!accessibleObject.isAccessible()) {
                    ((Field)accessibleObject).setAccessible(true);
                }
                if (accessibleObject.isAnnotationPresent(In.class)) {
                    this.inFields.add((Field)accessibleObject);
                }
                if (accessibleObject.isAnnotationPresent(Out.class)) {
                    this.outFields.add((Field)accessibleObject);
                }
                if (accessibleObject.isAnnotationPresent(DataModel.class)) {
                    this.checkDataModelScope(((Field)accessibleObject).getAnnotation(DataModel.class));
                }
                if (accessibleObject.isAnnotationPresent(RequestParameter.class)) {
                    this.parameterFields.add((Field)accessibleObject);
                }
                if (accessibleObject.isAnnotationPresent(Logger.class)) {
                    String category = ((Field)accessibleObject).getAnnotation(Logger.class).value();
                    Log logInstance = "".equals(category) ? Logging.getLog(this.beanClass) : Logging.getLog(category);
                    if (Modifier.isStatic(((Field)accessibleObject).getModifiers())) {
                        Reflections.setAndWrap((Field)accessibleObject, null, logInstance);
                    } else {
                        this.logFields.add((Field)accessibleObject);
                        this.logInstances.add(logInstance);
                    }
                }
                for (Annotation ann3 : accessibleObject.getAnnotations()) {
                    if (ann3.annotationType().isAnnotationPresent(DataBinderClass.class)) {
                        this.dataModelFields.add((Field)accessibleObject);
                        this.dataModelFieldAnnotations.put((Field)accessibleObject, ann3);
                    }
                    if (!ann3.annotationType().isAnnotationPresent(DataSelectorClass.class)) continue;
                    selectionFields.add(accessibleObject);
                    this.dataModelSelectionFieldAnnotations.put((Field)accessibleObject, ann3);
                }
            }
            clazz = clazz.getSuperclass();
        }
        boolean hasMultipleDataModels = this.dataModelGetters.size() + this.dataModelFields.size() > 1;
        String defaultDataModelName = null;
        if (!hasMultipleDataModels) {
            String name;
            if (!this.dataModelGetters.isEmpty()) {
                Method dataModelGetter = this.dataModelGetters.get(0);
                Annotation annotation = this.dataModelGetterAnnotations.get(dataModelGetter);
                name = Component.createWrapper(annotation).getVariableName(annotation);
                defaultDataModelName = Component.toName(name, dataModelGetter);
            } else if (!this.dataModelFields.isEmpty()) {
                Field dataModelField = this.dataModelFields.get(0);
                Annotation annotation = this.dataModelFieldAnnotations.get(dataModelField);
                name = Component.createWrapper(annotation).getVariableName(annotation);
                defaultDataModelName = Component.toName(name, dataModelField);
            }
        }
        for (Method method : selectionSetters) {
            Method existing;
            ann = this.dataModelSelectionSetterAnnotations.get(method);
            String name = Component.createUnwrapper(ann).getVariableName(ann);
            if (name.length() == 0) {
                if (hasMultipleDataModels) {
                    throw new IllegalStateException("Missing value() for @DataModelSelection with multiple @DataModels");
                }
                name = defaultDataModelName;
            }
            if ((existing = this.dataModelSelectionSetters.put(name, method)) == null) continue;
            throw new IllegalStateException("Multiple @DataModelSelection setters for: " + name);
        }
        for (Field field : selectionFields) {
            Field existing;
            ann = this.dataModelSelectionFieldAnnotations.get(field);
            String name = Component.createUnwrapper(ann).getVariableName(ann);
            if (name.length() == 0) {
                if (hasMultipleDataModels) {
                    throw new IllegalStateException("Missing value() for @DataModelSelection with multiple @DataModels");
                }
                name = defaultDataModelName;
            }
            if ((existing = this.dataModelSelectionFields.put(name, field)) == null) continue;
            throw new IllegalStateException("Multiple @DataModelSelection fields for: " + name);
        }
    }

    private void checkDataModelScope(DataModel dataModel) {
        ScopeType dataModelScope = dataModel.scope();
        if (dataModelScope != ScopeType.PAGE && dataModelScope != ScopeType.UNSPECIFIED) {
            throw new IllegalArgumentException("@DataModel scope must be ScopeType.UNSPECIFIED or ScopeType.PAGE: " + this.name);
        }
    }

    private void initInterceptors() {
        this.initDefaultInterceptors();
        for (Annotation annotation : this.beanClass.getAnnotations()) {
            Class[] classes;
            if (annotation.annotationType().isAnnotationPresent(EJB.INTERCEPTORS)) {
                classes = EJB.value(annotation.annotationType().getAnnotation(EJB.INTERCEPTORS));
                this.addInterceptor(new Interceptor(classes, annotation, this));
            }
            if (!annotation.annotationType().isAnnotationPresent(Interceptors.class)) continue;
            classes = annotation.annotationType().getAnnotation(Interceptors.class).value();
            this.addInterceptor(new Interceptor(classes, annotation, this));
        }
        this.newSort(this.interceptors);
        if (log.isDebugEnabled()) {
            log.debug("interceptor stack: " + this.interceptors);
        }
    }

    public void addInterceptor(Interceptor interceptor) {
        if (interceptor.getType() == InterceptorType.SERVER) {
            this.interceptors.add(interceptor);
        } else {
            this.clientSideInterceptors.add(interceptor);
        }
    }

    private List<Interceptor> newSort(List<Interceptor> list) {
        List siList = new ArrayList();
        HashMap<Class, SortItem<Interceptor>> ht = new HashMap<Class, SortItem<Interceptor>>();
        for (Interceptor interceptor : list) {
            SortItem<Interceptor> sortItem = new SortItem<Interceptor>(interceptor);
            siList.add(sortItem);
            ht.put(interceptor.getUserInterceptorClass(), sortItem);
        }
        for (SortItem sortItem : siList) {
            SortItem sortItem2;
            Class clazz = ((Interceptor)sortItem.getObj()).getUserInterceptorClass();
            if (!clazz.isAnnotationPresent(org.jboss.seam.annotations.Interceptor.class)) continue;
            org.jboss.seam.annotations.Interceptor interceptorAnn = clazz.getAnnotation(org.jboss.seam.annotations.Interceptor.class);
            for (Class cl : Arrays.asList(interceptorAnn.around())) {
                sortItem2 = (SortItem)ht.get(cl);
                if (sortItem2 == null) continue;
                sortItem.getAround().add(sortItem2);
            }
            for (Class cl : Arrays.asList(interceptorAnn.within())) {
                sortItem2 = (SortItem)ht.get(cl);
                if (sortItem2 == null) continue;
                sortItem.getWithin().add(sortItem2);
            }
        }
        SorterNew sList = new SorterNew();
        siList = sList.sort(siList);
        list.clear();
        for (SortItem sortItem : siList) {
            list.add((Interceptor)sortItem.getObj());
        }
        return list;
    }

    private void initDefaultInterceptors() {
        if (this.synchronize) {
            this.addInterceptor(new Interceptor(new SynchronizationInterceptor(), this));
        }
        if (this.getType().isEjb() && this.businessInterfaceHasAnnotation(Asynchronous.class) || this.getType() == ComponentType.JAVA_BEAN && this.beanClassHasAnnotation(Asynchronous.class)) {
            this.addInterceptor(new Interceptor(new AsynchronousInterceptor(), this));
        }
        if (this.getType() == ComponentType.STATEFUL_SESSION_BEAN) {
            this.addInterceptor(new Interceptor(new RemoveInterceptor(), this));
        }
        if (this.getType() != ComponentType.ENTITY_BEAN) {
            this.addInterceptor(new Interceptor(new MethodContextInterceptor(), this));
        }
        if (this.beanClassHasAnnotation(RaiseEvent.class)) {
            this.addInterceptor(new Interceptor(new EventInterceptor(), this));
        }
        if (this.beanClassHasAnnotation(Conversational.class)) {
            this.addInterceptor(new Interceptor(new ConversationalInterceptor(), this));
        }
        if (Contexts.isApplicationContextActive() && Init.instance().isJbpmInstalled()) {
            this.addInterceptor(new Interceptor(new BusinessProcessInterceptor(), this));
        }
        this.addInterceptor(new Interceptor(new ConversationInterceptor(), this));
        this.addInterceptor(new Interceptor(new OutcomeInterceptor(), this));
        if (this.needsInjection() || this.needsOutjection()) {
            this.addInterceptor(new Interceptor(new BijectionInterceptor(), this));
        }
        if (this.beanClassHasAnnotation(IfInvalid.class)) {
            this.addInterceptor(new Interceptor(new ValidationInterceptor(), this));
        }
        if (this.getType() == ComponentType.JAVA_BEAN || this.beanClassHasAnnotation(Rollback.class)) {
            this.addInterceptor(new Interceptor(new RollbackInterceptor(), this));
        }
        if (this.getType() == ComponentType.JAVA_BEAN && this.beanClassHasAnnotation(Transactional.class)) {
            this.addInterceptor(new Interceptor(new TransactionInterceptor(), this));
        }
        if (this.getScope() == ScopeType.CONVERSATION) {
            this.addInterceptor(new Interceptor(new ManagedEntityIdentityInterceptor(), this));
        }
        if (this.beanClassHasAnnotation(Restrict.class)) {
            this.addInterceptor(new Interceptor(new SecurityInterceptor(), this));
        }
    }

    private static boolean hasAnnotation(Class clazz, Class annotationType) {
        if (clazz.isAnnotationPresent(annotationType)) {
            return true;
        }
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(annotationType)) continue;
            return true;
        }
        return false;
    }

    public boolean beanClassHasAnnotation(Class annotationType) {
        return Component.hasAnnotation(this.getBeanClass(), annotationType);
    }

    public boolean businessInterfaceHasAnnotation(Class annotationType) {
        for (Class businessInterface : this.getBusinessInterfaces()) {
            if (!Component.hasAnnotation(businessInterface, annotationType)) continue;
            return true;
        }
        return false;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public String getName() {
        return this.name;
    }

    public ComponentType getType() {
        return this.type;
    }

    public ScopeType getScope() {
        return this.scope;
    }

    public ClassValidator getValidator() {
        java.util.ResourceBundle bundle = Contexts.isApplicationContextActive() ? ResourceBundle.instance() : null;
        Locale locale = bundle == null ? new Locale("DUMMY") : bundle.getLocale();
        ClassValidator validator = this.validators.get(locale);
        if (validator == null) {
            validator = bundle == null ? new ClassValidator(this.beanClass) : new ClassValidator(this.beanClass, bundle);
            this.validators.put(locale, validator);
        }
        return validator;
    }

    public List<Interceptor> getInterceptors(InterceptorType type) {
        switch (type) {
            case SERVER: {
                return this.interceptors;
            }
            case CLIENT: {
                return this.clientSideInterceptors;
            }
            case ANY: {
                ArrayList<Interceptor> all = new ArrayList<Interceptor>();
                all.addAll(this.clientSideInterceptors);
                all.addAll(this.interceptors);
                return all;
            }
        }
        throw new IllegalArgumentException("no interceptor type specified");
    }

    public List<Object> createUserInterceptors(InterceptorType type) {
        List<Interceptor> interceptors = this.getInterceptors(type);
        ArrayList<Object> result = new ArrayList<Object>(interceptors.size());
        for (Interceptor interceptor : interceptors) {
            result.add(interceptor.createUserInterceptor());
        }
        return result;
    }

    public List<Interceptor> getServerSideInterceptors() {
        return this.getInterceptors(InterceptorType.SERVER);
    }

    public List<Interceptor> getClientSideInterceptors() {
        return this.getInterceptors(InterceptorType.CLIENT);
    }

    public Method getDestroyMethod() {
        return this.destroyMethod;
    }

    public Collection<Method> getRemoveMethods() {
        return this.removeMethods.values();
    }

    public Method getRemoveMethod(String name) {
        return this.removeMethods.get(name);
    }

    public Set<Method> getValidateMethods() {
        return this.validateMethods;
    }

    public boolean hasPreDestroyMethod() {
        return this.preDestroyMethod != null;
    }

    public boolean hasPostConstructMethod() {
        return this.postConstructMethod != null;
    }

    public boolean hasPrePassivateMethod() {
        return this.prePassivateMethod != null;
    }

    public boolean hasPostActivateMethod() {
        return this.postActivateMethod != null;
    }

    public boolean hasDestroyMethod() {
        return this.destroyMethod != null;
    }

    public boolean hasCreateMethod() {
        return this.createMethod != null;
    }

    public Method getCreateMethod() {
        return this.createMethod;
    }

    public boolean hasUnwrapMethod() {
        return this.unwrapMethod != null;
    }

    public Method getUnwrapMethod() {
        return this.unwrapMethod;
    }

    public Set<Field> getOutFields() {
        return this.outFields;
    }

    public Set<Method> getOutMethods() {
        return this.outMethods;
    }

    public Set<Method> getInMethods() {
        return this.inMethods;
    }

    public Set<Field> getInFields() {
        return this.inFields;
    }

    public boolean needsInjection() {
        return !this.getInFields().isEmpty() || !this.getInMethods().isEmpty() || !this.dataModelSelectionSetters.isEmpty() || !this.dataModelSelectionFields.isEmpty() || !this.parameterFields.isEmpty() || !this.parameterSetters.isEmpty();
    }

    public boolean needsOutjection() {
        return !this.getOutFields().isEmpty() || !this.getOutMethods().isEmpty() || !this.dataModelGetters.isEmpty() || !this.dataModelFields.isEmpty();
    }

    protected Object instantiate() throws Exception {
        switch (this.type) {
            case JAVA_BEAN: {
                return this.instantiateJavaBean();
            }
            case ENTITY_BEAN: {
                return this.instantiateEntityBean();
            }
            case STATELESS_SESSION_BEAN: 
            case STATEFUL_SESSION_BEAN: {
                return this.instantiateSessionBean();
            }
            case MESSAGE_DRIVEN_BEAN: {
                throw new UnsupportedOperationException("Message-driven beans may not be called: " + this.name);
            }
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object instantiateSessionBean() throws Exception, NamingException {
        Component old = (Component)SeamInterceptor.COMPONENT.get();
        SeamInterceptor.COMPONENT.set(this);
        try {
            Object bean = Naming.getInitialContext().lookup(this.jndiName);
            Object object = this.wrap(bean, new ClientSideInterceptor(bean, this));
            return object;
        }
        finally {
            SeamInterceptor.COMPONENT.set(old);
        }
    }

    protected Object instantiateEntityBean() throws Exception {
        Object bean = this.beanClass.newInstance();
        this.initialize(bean);
        return bean;
    }

    protected Object instantiateJavaBean() throws Exception {
        Object bean = this.beanClass.newInstance();
        if (this.interceptionType == InterceptionType.NEVER) {
            this.initialize(bean);
            this.callPostConstructMethod(bean);
        } else {
            JavaBeanInterceptor interceptor = new JavaBeanInterceptor(bean, this);
            bean = this.wrap(bean, interceptor);
            interceptor.postConstruct();
        }
        return bean;
    }

    public Object wrap(Object bean, MethodInterceptor interceptor) throws Exception {
        net.sf.cglib.proxy.Factory proxy = this.getProxyFactory().newInstance();
        proxy.setCallback(0, (Callback)interceptor);
        return proxy;
    }

    private synchronized Class<net.sf.cglib.proxy.Factory> getProxyFactory() {
        if (this.factory == null) {
            this.factory = Component.createProxyFactory(this.getType(), this.getBeanClass(), this.getBusinessInterfaces());
        }
        return this.factory;
    }

    public void initialize(Object bean) throws Exception {
        Object initialValue;
        if (log.isDebugEnabled()) {
            log.debug("initializing new instance of: " + this.name);
        }
        this.injectLog(bean);
        for (Map.Entry<Method, InitialValue> entry : this.initializerSetters.entrySet()) {
            Method method = entry.getKey();
            initialValue = entry.getValue().getValue(method.getParameterTypes()[0]);
            this.setPropertyValue(bean, method, method.getName(), initialValue);
        }
        for (Map.Entry<AccessibleObject, InitialValue> entry : this.initializerFields.entrySet()) {
            Field field = (Field)entry.getKey();
            initialValue = entry.getValue().getValue(field.getType());
            this.setFieldValue(bean, field, field.getName(), initialValue);
        }
        if (log.isDebugEnabled()) {
            log.debug("done initializing: " + this.name);
        }
    }

    public void inject(Object bean, boolean enforceRequired) {
        this.injectMethods(bean, enforceRequired);
        this.injectFields(bean, enforceRequired);
        this.injectDataModelSelection(bean);
        this.injectParameters(bean);
    }

    public void disinject(Object bean) {
        this.disinjectMethods(bean);
        this.disinjectFields(bean);
    }

    private void injectLog(Object bean) {
        for (int i = 0; i < this.logFields.size(); ++i) {
            this.setFieldValue(bean, this.logFields.get(i), "log", this.logInstances.get(i));
        }
    }

    private void injectParameters(Object bean) {
        Object convertedValue;
        String name;
        Map<String, String[]> requestParameters = Parameters.getRequestParameters();
        for (Method setter : this.parameterSetters) {
            name = Component.toName(setter.getAnnotation(RequestParameter.class).value(), setter);
            Class<?> setterType = setter.getParameterTypes()[0];
            convertedValue = Parameters.convertMultiValueRequestParameter(requestParameters, name, setterType);
            this.setPropertyValue(bean, setter, name, convertedValue);
        }
        for (Field field : this.parameterFields) {
            name = Component.toName(field.getAnnotation(RequestParameter.class).value(), field);
            Class<?> fieldType = field.getType();
            convertedValue = Parameters.convertMultiValueRequestParameter(requestParameters, name, fieldType);
            this.setFieldValue(bean, field, name, convertedValue);
        }
    }

    public void outject(Object bean, boolean enforceRequired) {
        this.outjectMethods(bean, enforceRequired);
        this.outjectFields(bean, enforceRequired);
        this.outjectDataModels(bean);
    }

    private void injectDataModelSelection(Object bean) {
        String name;
        DataBinder wrapper;
        Annotation dataModelAnn;
        for (Method dataModelGetter : this.dataModelGetters) {
            dataModelAnn = this.dataModelGetterAnnotations.get(dataModelGetter);
            wrapper = Component.createWrapper(dataModelAnn);
            name = Component.toName(wrapper.getVariableName(dataModelAnn), dataModelGetter);
            this.injectDataModelSelection(bean, name, null, wrapper, dataModelAnn);
        }
        for (Field dataModelField : this.dataModelFields) {
            dataModelAnn = this.dataModelFieldAnnotations.get(dataModelField);
            wrapper = Component.createWrapper(dataModelAnn);
            name = Component.toName(wrapper.getVariableName(dataModelAnn), dataModelField);
            this.injectDataModelSelection(bean, name, dataModelField, wrapper, dataModelAnn);
        }
    }

    private void injectDataModelSelection(Object bean, String name, Field dataModelField, DataBinder wrapper, Annotation dataModelAnn) {
        ScopeType scope = wrapper.getVariableScope(dataModelAnn);
        Object dataModel = Component.getOutScope(scope, this).getContext().get(name);
        if (dataModel != null) {
            if (dataModelField != null) {
                this.setFieldValue(bean, dataModelField, name, wrapper.getWrappedData(dataModelAnn, dataModel));
            }
            Object selectedIndex = wrapper.getSelection(dataModelAnn, dataModel);
            if (log.isDebugEnabled()) {
                log.debug("selected row: " + selectedIndex);
            }
            if (selectedIndex != null) {
                Field field;
                Method setter = this.dataModelSelectionSetters.get(name);
                if (setter != null) {
                    Annotation dataModelSelectionAnn = this.dataModelSelectionSetterAnnotations.get(setter);
                    Object selection = Component.createUnwrapper(dataModelSelectionAnn).getSelection(dataModelSelectionAnn, dataModel);
                    this.setPropertyValue(bean, setter, name, selection);
                }
                if ((field = this.dataModelSelectionFields.get(name)) != null) {
                    Annotation dataModelSelectionAnn = this.dataModelSelectionFieldAnnotations.get(field);
                    Object selection = Component.createUnwrapper(dataModelSelectionAnn).getSelection(dataModelSelectionAnn, dataModel);
                    this.setFieldValue(bean, field, name, selection);
                }
            }
        }
    }

    private void outjectDataModels(Object bean) {
        Object list;
        String name;
        DataBinder wrapper;
        Annotation dataModelAnn;
        for (Method dataModelGetter : this.dataModelGetters) {
            dataModelAnn = this.dataModelGetterAnnotations.get(dataModelGetter);
            wrapper = Component.createWrapper(dataModelAnn);
            name = Component.toName(wrapper.getVariableName(dataModelAnn), dataModelGetter);
            list = this.getPropertyValue(bean, dataModelGetter, name);
            this.outjectDataModelList(name, list, wrapper, dataModelAnn);
        }
        for (Field dataModelField : this.dataModelFields) {
            dataModelAnn = this.dataModelFieldAnnotations.get(dataModelField);
            wrapper = Component.createWrapper(dataModelAnn);
            name = Component.toName(wrapper.getVariableName(dataModelAnn), dataModelField);
            list = this.getFieldValue(bean, dataModelField, name);
            this.outjectDataModelList(name, list, wrapper, dataModelAnn);
        }
    }

    private static DataBinder createWrapper(Annotation dataModelAnn) {
        try {
            return dataModelAnn.annotationType().getAnnotation(DataBinderClass.class).value().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static DataSelector createUnwrapper(Annotation dataModelAnn) {
        try {
            return dataModelAnn.annotationType().getAnnotation(DataSelectorClass.class).value().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void outjectDataModelList(String name, Object list, DataBinder wrapper, Annotation dataModelAnn) {
        boolean dirty;
        ScopeType scope = wrapper.getVariableScope(dataModelAnn);
        Context context = Component.getOutScope(scope, this).getContext();
        Object existingDataModel = context.get(name);
        boolean bl = dirty = existingDataModel == null || scope == ScopeType.PAGE || wrapper.isDirty(dataModelAnn, existingDataModel, list);
        if (dirty) {
            if (list != null) {
                context.set(name, wrapper.wrap(dataModelAnn, list));
            } else {
                context.remove(name);
            }
        }
    }

    private static ScopeType getOutScope(ScopeType specifiedScope, Component component) {
        ScopeType scope;
        ScopeType scopeType = scope = component == null ? ScopeType.EVENT : component.getScope();
        if (scope == ScopeType.STATELESS) {
            scope = ScopeType.EVENT;
        }
        if (specifiedScope != ScopeType.UNSPECIFIED) {
            scope = specifiedScope;
        }
        return scope;
    }

    private void injectMethods(Object bean, boolean enforceRequired) {
        for (Method method : this.getInMethods()) {
            In in = method.getAnnotation(In.class);
            String name = Component.toName(in.value(), method);
            this.setPropertyValue(bean, method, name, this.getInstanceToInject(in, name, bean, enforceRequired));
        }
    }

    private void disinjectMethods(Object bean) {
        for (Method method : this.getInMethods()) {
            if (method.getParameterTypes()[0].isPrimitive()) continue;
            String name = Component.toName(method.getAnnotation(In.class).value(), method);
            this.setPropertyValue(bean, method, name, null);
        }
    }

    private void injectFields(Object bean, boolean enforceRequired) {
        for (Field field : this.getInFields()) {
            In in = field.getAnnotation(In.class);
            String name = Component.toName(in.value(), field);
            this.setFieldValue(bean, field, name, this.getInstanceToInject(in, name, bean, enforceRequired));
        }
    }

    private void disinjectFields(Object bean) {
        for (Field field : this.getInFields()) {
            if (field.getType().isPrimitive()) continue;
            String name = Component.toName(field.getAnnotation(In.class).value(), field);
            this.setFieldValue(bean, field, name, null);
        }
    }

    private void outjectFields(Object bean, boolean enforceRequired) {
        for (Field field : this.getOutFields()) {
            Out out = field.getAnnotation(Out.class);
            if (out == null) continue;
            String name = Component.toName(out.value(), field);
            this.setOutjectedValue(out, name, this.getFieldValue(bean, field, name), enforceRequired);
        }
    }

    private void outjectMethods(Object bean, boolean enforceRequired) {
        for (Method method : this.getOutMethods()) {
            Out out = method.getAnnotation(Out.class);
            if (out == null) continue;
            String name = Component.toName(out.value(), method);
            this.setOutjectedValue(out, name, this.getPropertyValue(bean, method, name), enforceRequired);
        }
    }

    private void setOutjectedValue(Out out, String name, Object value, boolean enforceRequired) {
        ScopeType outScope;
        if (value == null && enforceRequired && out.required()) {
            throw new RequiredException("Out attribute requires value for component: " + this.getAttributeMessage(name));
        }
        Component component = null;
        if (out.scope() == ScopeType.UNSPECIFIED) {
            component = Component.forName(name);
            if (value != null && component != null && !component.isInstance(value)) {
                throw new IllegalArgumentException("attempted to bind an Out attribute of the wrong type to: " + this.getAttributeMessage(name));
            }
        } else if (out.scope() == ScopeType.STATELESS) {
            throw new IllegalArgumentException("cannot specify explicit scope=STATELESS on @Out: " + this.getAttributeMessage(name));
        }
        ScopeType scopeType = outScope = component == null ? Component.getOutScope(out.scope(), this) : component.getScope();
        if (enforceRequired || outScope.isContextActive()) {
            if (value == null) {
                outScope.getContext().remove(name);
            } else {
                outScope.getContext().set(name, value);
            }
        }
    }

    public boolean isInstance(Object bean) {
        switch (this.type) {
            case ENTITY_BEAN: 
            case JAVA_BEAN: {
                return this.beanClass.isInstance(bean);
            }
        }
        Class<?> clazz = bean.getClass();
        for (Class businessInterface : this.businessInterfaces) {
            if (!businessInterface.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static Set<Class> getBusinessInterfaces(Class clazz) {
        HashSet<Class> result = new HashSet<Class>();
        if (clazz.isAnnotationPresent(EJB.LOCAL)) {
            for (Class clazz2 : EJB.value(clazz.getAnnotation(EJB.LOCAL))) {
                result.add(clazz2);
            }
        }
        if (clazz.isAnnotationPresent(EJB.REMOTE)) {
            for (Class clazz3 : EJB.value(clazz.getAnnotation(EJB.REMOTE))) {
                result.add(clazz3);
            }
        }
        for (Class clazz4 : clazz.getInterfaces()) {
            if (!clazz4.isAnnotationPresent(EJB.LOCAL) && !clazz4.isAnnotationPresent(EJB.REMOTE)) continue;
            result.add(clazz4);
        }
        if (result.size() == 0) {
            for (Class clazz5 : clazz.getInterfaces()) {
                if (Component.isExcludedLocalInterfaceName(clazz5.getName())) continue;
                result.add(clazz5);
            }
        }
        return result;
    }

    public Set<Class> getBusinessInterfaces() {
        return this.businessInterfaces;
    }

    private static boolean isExcludedLocalInterfaceName(String name) {
        return name.equals("java.io.Serializable") || name.equals("java.io.Externalizable") || name.startsWith("javax.ejb.");
    }

    private Object getFieldValue(Object bean, Field field, String name) {
        try {
            return Reflections.get(field, bean);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not get field value: " + this.getAttributeMessage(name), e);
        }
    }

    private Object getPropertyValue(Object bean, Method method, String name) {
        try {
            return Reflections.invoke(method, bean, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not get property value: " + this.getAttributeMessage(name), e);
        }
    }

    private void setPropertyValue(Object bean, Method method, String name, Object value) {
        try {
            Reflections.invoke(method, bean, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not set property value: " + this.getAttributeMessage(name), e);
        }
    }

    private void setFieldValue(Object bean, Field field, String name, Object value) {
        try {
            Reflections.set(field, bean, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not set field value: " + this.getAttributeMessage(name), e);
        }
    }

    public static Component forName(String name) {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No application context active");
        }
        return (Component)Contexts.getApplicationContext().get(name + ".component");
    }

    public static Object getInstance(Class<?> clazz) {
        return Component.getInstance(clazz, true);
    }

    public static Object getInstance(Class<?> clazz, boolean create) {
        return Component.getInstance(Seam.getComponentName(clazz), create);
    }

    public static Object getInstance(Class<?> clazz, ScopeType scope) {
        return Component.getInstance(clazz, scope, true);
    }

    public static Object getInstance(Class<?> clazz, ScopeType scope, boolean create) {
        return Component.getInstance(Seam.getComponentName(clazz), scope, create);
    }

    public static Object getInstance(String name) {
        return Component.getInstance(name, true);
    }

    public static Object getInstance(String name, boolean create) {
        Object result = Contexts.lookupInStatefulContexts(name);
        result = Component.getInstance(name, create, result);
        return result;
    }

    public static Object getInstance(String name, ScopeType scope) {
        return Component.getInstance(name, scope, true);
    }

    public static Object getInstance(String name, ScopeType scope, boolean create) {
        Object result = scope == ScopeType.STATELESS ? null : scope.getContext().get(name);
        result = Component.getInstance(name, create, result);
        return result;
    }

    private static Object getInstance(String name, boolean create, Object result) {
        Component component = Component.forName(name);
        boolean bl = create = create || Init.instance().isAutocreateVariable(name);
        if (result == null && create && (result = Component.getInstanceFromFactory(name)) == null) {
            if (component == null) {
                if (log.isDebugEnabled()) {
                    log.debug("seam component not found: " + name);
                }
            } else if (component.getScope().isContextActive()) {
                result = component.newInstance();
            }
        }
        if (result != null && component != null) {
            if (!component.isInstance(result)) {
                if (component.hasUnwrapMethod()) {
                    return result;
                }
                throw new IllegalArgumentException("value of context variable is not an instance of the component bound to the context variable: " + name);
            }
            result = component.unwrap(result);
        }
        return result;
    }

    public static Object getInstanceFromFactory(String name) {
        Init init = Init.instance();
        if (init == null) {
            return null;
        }
        Init.FactoryMethod factoryMethod = init.getFactory(name);
        Init.FactoryBinding methodBinding = init.getFactoryMethodBinding(name);
        Init.FactoryBinding valueBinding = init.getFactoryValueBinding(name);
        if (methodBinding != null && Component.getOutScope(methodBinding.getScope(), null).isContextActive()) {
            Object result = methodBinding.getMethodBinding().invoke(new Object[0]);
            return Component.handleFactoryMethodResult(name, null, result, methodBinding.getScope());
        }
        if (valueBinding != null && Component.getOutScope(valueBinding.getScope(), null).isContextActive()) {
            Object result = valueBinding.getValueBinding().getValue();
            return Component.handleFactoryMethodResult(name, null, result, valueBinding.getScope());
        }
        if (factoryMethod != null && Component.getOutScope(factoryMethod.getScope(), factoryMethod.getComponent()).isContextActive()) {
            Object factory = Component.getInstance(factoryMethod.getComponent().getName(), true);
            if (factory == null) {
                return null;
            }
            Object result = factoryMethod.getComponent().callComponentMethod(factory, factoryMethod.getMethod(), new Object[0]);
            return Component.handleFactoryMethodResult(name, factoryMethod.getComponent(), result, factoryMethod.getScope());
        }
        return null;
    }

    private static Object handleFactoryMethodResult(String name, Component component, Object result, ScopeType scope) {
        Object value = Contexts.lookupInStatefulContexts(name);
        if (value == null) {
            ScopeType outScope = Component.getOutScope(scope, component);
            if (outScope != ScopeType.STATELESS) {
                outScope.getContext().set(name, result);
            }
            return result;
        }
        if (scope != ScopeType.UNSPECIFIED) {
            throw new IllegalArgumentException("factory method with defined scope outjected a value: " + name);
        }
        return value;
    }

    public Object newInstance() {
        Object instance;
        if (log.isDebugEnabled()) {
            log.debug("instantiating Seam component: " + this.name);
        }
        try {
            instance = this.instantiate();
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate Seam component: " + this.name, e);
        }
        if (this.getScope() != ScopeType.STATELESS) {
            this.getScope().getContext().set(this.name, instance);
            this.callCreateMethod(instance);
            if (Events.exists()) {
                Events.instance().raiseEvent("org.jboss.seam.postCreate." + this.name, new Object[0]);
            }
        }
        return instance;
    }

    public void callCreateMethod(Object instance) {
        if (this.hasCreateMethod()) {
            this.callComponentMethod(instance, this.getCreateMethod(), new Object[0]);
        }
    }

    public void callDestroyMethod(Object instance) {
        if (this.hasDestroyMethod()) {
            this.callComponentMethod(instance, this.getDestroyMethod(), new Object[0]);
        }
    }

    public void callPreDestroyMethod(Object instance) {
        if (this.hasPreDestroyMethod()) {
            this.callComponentMethod(instance, this.getPreDestroyMethod(), new Object[0]);
        }
    }

    public void callPostConstructMethod(Object instance) {
        if (this.hasPostConstructMethod()) {
            this.callComponentMethod(instance, this.getPostConstructMethod(), new Object[0]);
        }
    }

    public void callPrePassivateMethod(Object instance) {
        if (this.hasPrePassivateMethod()) {
            this.callComponentMethod(instance, this.getPrePassivateMethod(), new Object[0]);
        }
    }

    public void callPostActivateMethod(Object instance) {
        if (this.hasPostActivateMethod()) {
            this.callComponentMethod(instance, this.getPostActivateMethod(), new Object[0]);
        }
    }

    public Object callComponentMethod(Object instance, Method method, Object ... parameters) {
        Class<?>[] paramTypes = method.getParameterTypes();
        String methodName = method.getName();
        try {
            Method interfaceMethod = instance.getClass().getMethod(methodName, paramTypes);
            if (paramTypes.length == 0 || interfaceMethod.getParameterTypes().length == 0) {
                return Reflections.invokeAndWrap(interfaceMethod, instance, new Object[0]);
            }
            if (parameters.length > 0) {
                return Reflections.invokeAndWrap(interfaceMethod, instance, parameters);
            }
            return Reflections.invokeAndWrap(interfaceMethod, instance, this);
        }
        catch (NoSuchMethodException e) {
            String message = "method not found: " + method.getName() + " for component: " + this.name;
            if (this.getType().isSessionBean()) {
                message = message + " (check that it is declared on the session bean business interface)";
            }
            throw new IllegalArgumentException(message, e);
        }
    }

    private Object unwrap(Object instance) {
        if (this.hasUnwrapMethod()) {
            return this.callComponentMethod(instance, this.getUnwrapMethod(), new Object[0]);
        }
        return instance;
    }

    private Object getInstanceToInject(In in, String name, Object bean, boolean enforceRequired) {
        Object result;
        if (name.startsWith("#")) {
            if (log.isDebugEnabled()) {
                log.debug("trying to inject with EL expression: " + name);
            }
            result = Expressions.instance().createValueBinding(name).getValue();
        } else if (in.scope() == ScopeType.UNSPECIFIED) {
            if (log.isDebugEnabled()) {
                log.debug("trying to inject with hierarchical context search: " + name);
            }
            result = Component.getInstance(name, in.create() && !Lifecycle.isDestroying());
        } else {
            if (in.create()) {
                throw new IllegalArgumentException("cannot combine create=true with explicit scope on @In: " + this.getAttributeMessage(name));
            }
            if (in.scope() == ScopeType.STATELESS) {
                throw new IllegalArgumentException("cannot specify explicit scope=STATELESS on @In: " + this.getAttributeMessage(name));
            }
            if (log.isDebugEnabled()) {
                log.debug("trying to inject from specified context: " + name + ", scope: " + (Object)((Object)this.scope));
            }
            if (enforceRequired || in.scope().isContextActive()) {
                result = in.scope().getContext().get(name);
            } else {
                return null;
            }
        }
        if (result == null && enforceRequired && in.required()) {
            throw new RequiredException("In attribute requires value for component: " + this.getAttributeMessage(name));
        }
        return result;
    }

    private String getAttributeMessage(String attributeName) {
        return this.getName() + '.' + attributeName;
    }

    private static String toName(String name, Method method) {
        if (name == null || name.length() == 0) {
            name = method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
        }
        return name;
    }

    private static String toName(String name, Field field) {
        if (name == null || name.length() == 0) {
            name = field.getName();
        }
        return name;
    }

    public String toString() {
        return "Component(" + this.name + ")";
    }

    public static Class<net.sf.cglib.proxy.Factory> createProxyFactory(ComponentType type, Class beanClass, Collection<Class> businessInterfaces) {
        Enhancer en = new Enhancer();
        en.setUseCache(false);
        en.setInterceptDuringConstruction(false);
        en.setCallbackType(MethodInterceptor.class);
        en.setSuperclass(type == ComponentType.JAVA_BEAN ? beanClass : Object.class);
        HashSet<Class<Proxy>> interfaces = new HashSet<Class<Proxy>>();
        if (type.isSessionBean()) {
            interfaces.addAll(businessInterfaces);
        } else {
            interfaces.add(HttpSessionActivationListener.class);
            interfaces.add(Mutable.class);
        }
        interfaces.add(Proxy.class);
        en.setInterfaces(interfaces.toArray(new Class[0]));
        return en.createClass();
    }

    public InterceptionType getInterceptionType() {
        return this.interceptionType;
    }

    public boolean isStartup() {
        return this.startup;
    }

    public String[] getDependencies() {
        return this.dependencies;
    }

    public Method getPostActivateMethod() {
        return this.postActivateMethod;
    }

    public Method getPrePassivateMethod() {
        return this.prePassivateMethod;
    }

    public Method getPostConstructMethod() {
        return this.postConstructMethod;
    }

    public Method getPreDestroyMethod() {
        return this.preDestroyMethod;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public static class MapInitialValue
    implements InitialValue {
        private Map<InitialValue, InitialValue> initialValues;
        private Class elementType;
        private Class keyType;

        public MapInitialValue(Conversions.PropertyValue propertyValue, Class collectionClass, Type collectionType) {
            Map<String, String> expressions = propertyValue.getKeyedValues();
            this.initialValues = new HashMap<InitialValue, InitialValue>(expressions.size());
            this.elementType = Reflections.getCollectionElementType(collectionType);
            this.keyType = Reflections.getMapKeyType(collectionType);
            for (Map.Entry<String, String> me : expressions.entrySet()) {
                Conversions.FlatPropertyValue keyValue = new Conversions.FlatPropertyValue(me.getKey());
                Conversions.FlatPropertyValue elementValue = new Conversions.FlatPropertyValue(me.getValue());
                this.initialValues.put(Component.getInitialValue(keyValue, this.keyType, this.keyType), Component.getInitialValue(elementValue, this.elementType, this.elementType));
            }
        }

        public Object getValue(Class type) {
            HashMap<Object, Object> result = new HashMap<Object, Object>(this.initialValues.size());
            for (Map.Entry<InitialValue, InitialValue> me : this.initialValues.entrySet()) {
                result.put(me.getKey().getValue(this.keyType), me.getValue().getValue(this.elementType));
            }
            return result;
        }

        public String toString() {
            return "MapInitialValue(" + this.keyType.getSimpleName() + "," + this.elementType.getSimpleName() + ")";
        }
    }

    public static class ListInitialValue
    implements InitialValue {
        private InitialValue[] initialValues;
        private Class elementType;
        private boolean isArray;

        public ListInitialValue(Conversions.PropertyValue propertyValue, Class collectionClass, Type collectionType) {
            String[] expressions = propertyValue.getMultiValues();
            this.initialValues = new InitialValue[expressions.length];
            this.isArray = collectionClass.isArray();
            this.elementType = this.isArray ? collectionClass.getComponentType() : Reflections.getCollectionElementType(collectionType);
            for (int i = 0; i < expressions.length; ++i) {
                Conversions.FlatPropertyValue elementValue = new Conversions.FlatPropertyValue(expressions[i]);
                this.initialValues[i] = Component.getInitialValue(elementValue, this.elementType, this.elementType);
            }
        }

        public Object getValue(Class type) {
            if (this.isArray) {
                Object array = Array.newInstance(this.elementType, this.initialValues.length);
                for (int i = 0; i < this.initialValues.length; ++i) {
                    Array.set(array, i, this.initialValues[i].getValue(this.elementType));
                }
                return array;
            }
            ArrayList<Object> list = new ArrayList<Object>(this.initialValues.length);
            for (InitialValue iv : this.initialValues) {
                list.add(iv.getValue(this.elementType));
            }
            return list;
        }

        public String toString() {
            return "ListInitialValue(" + this.elementType.getSimpleName() + ")";
        }
    }

    public static class ELInitialValue
    implements InitialValue {
        private String expression;
        private Conversions.Converter converter;
        private Type parameterType;

        public ELInitialValue(Conversions.PropertyValue propertyValue, Class parameterClass, Type parameterType) {
            this.expression = propertyValue.getSingleValue();
            this.parameterType = parameterType;
            try {
                this.converter = Conversions.getConverter(parameterClass);
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }

        public Object getValue(Class type) {
            Serializable value = type.equals(Expressions.ValueBinding.class) ? this.createValueBinding() : (type.equals(Expressions.MethodBinding.class) ? this.createMethodBinding() : this.createValueBinding().getValue());
            if (this.converter != null && value instanceof String) {
                return this.converter.toObject(new Conversions.FlatPropertyValue((String)((Object)value)), this.parameterType);
            }
            if (this.converter != null && value instanceof String[]) {
                return this.converter.toObject(new Conversions.MultiPropertyValue((String[])value), this.parameterType);
            }
            return value;
        }

        private Expressions.ValueBinding createValueBinding() {
            return Expressions.instance().createValueBinding(this.expression);
        }

        private Expressions.MethodBinding createMethodBinding() {
            return Expressions.instance().createMethodBinding(this.expression);
        }

        public String toString() {
            return "ELInitialValue(" + this.expression + ")";
        }
    }

    public static class ConstantInitialValue
    implements InitialValue {
        private Object value;

        public ConstantInitialValue(Conversions.PropertyValue propertyValue, Class parameterClass, Type parameterType) {
            this.value = Conversions.getConverter(parameterClass).toObject(propertyValue, parameterType);
        }

        public Object getValue(Class type) {
            return this.value;
        }

        public String toString() {
            return "ConstantInitialValue(" + this.value + ")";
        }
    }

    public static interface InitialValue {
        public Object getValue(Class var1);
    }
}

