/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.FlushModeType;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Filter;
import org.jboss.seam.core.Mutable;
import org.jboss.seam.core.PersistenceContextManager;
import org.jboss.seam.core.PersistenceContexts;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Naming;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.CONVERSATION)
@Intercept(value=InterceptionType.NEVER)
public class ManagedHibernateSession
implements Serializable,
HttpSessionActivationListener,
Mutable,
PersistenceContextManager {
    private static final long serialVersionUID = 3130309555079841107L;
    private static final LogProvider log = Logging.getLogProvider(ManagedHibernateSession.class);
    private Session session;
    private String sessionFactoryJndiName;
    private String componentName;
    private Expressions.ValueBinding<SessionFactory> sessionFactory;
    private List<Filter> filters = new ArrayList<Filter>(0);

    @Override
    public boolean clearDirty() {
        return true;
    }

    @Create
    public void create(Component component) {
        this.componentName = component.getName();
        if (this.sessionFactoryJndiName == null) {
            this.sessionFactoryJndiName = "java:/" + this.componentName;
        }
        PersistenceContexts.instance().touch(this.componentName);
    }

    private void initSession() {
        this.session = this.getSessionFactoryFromJndiOrValueBinding().openSession();
        this.setSessionFlushMode(PersistenceContexts.instance().getFlushMode());
        for (Filter f : this.filters) {
            this.enableFilter(f);
        }
        if (log.isDebugEnabled()) {
            log.debug("created seam managed session for session factory: " + this.sessionFactoryJndiName);
        }
    }

    private void enableFilter(Filter f) {
        org.hibernate.Filter filter = this.session.enableFilter(f.getName());
        for (Map.Entry<String, Expressions.ValueBinding> me : f.getParameters().entrySet()) {
            filter.setParameter(me.getKey(), me.getValue().getValue());
        }
        filter.validate();
    }

    @Unwrap
    public Session getSession() {
        if (this.session == null) {
            this.initSession();
        }
        if (!Lifecycle.isDestroying()) {
            this.session.isOpen();
        }
        return this.session;
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        if (this.session != null && !this.session.isDirty()) {
            this.session.close();
            this.session = null;
        }
    }

    public void sessionDidActivate(HttpSessionEvent event) {
    }

    @Destroy
    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug("destroying seam managed session for session factory: " + this.sessionFactoryJndiName);
        }
        if (this.session != null) {
            this.session.close();
        }
    }

    private SessionFactory getSessionFactoryFromJndiOrValueBinding() {
        if (this.sessionFactory == null) {
            try {
                return (SessionFactory)Naming.getInitialContext().lookup(this.sessionFactoryJndiName);
            }
            catch (NamingException ne) {
                throw new IllegalArgumentException("SessionFactory not found in JNDI", ne);
            }
        }
        SessionFactory result = this.sessionFactory.getValue();
        if (result == null) {
            throw new IllegalStateException("SessionFactory not found");
        }
        return result;
    }

    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public void changeFlushMode(FlushModeType flushMode) {
        if (this.session != null) {
            this.setSessionFlushMode(flushMode);
        }
    }

    protected void setSessionFlushMode(FlushModeType flushMode) {
        switch (flushMode) {
            case AUTO: {
                this.session.setFlushMode(FlushMode.AUTO);
                break;
            }
            case MANUAL: {
                this.session.setFlushMode(FlushMode.NEVER);
                break;
            }
            case COMMIT: {
                this.session.setFlushMode(FlushMode.COMMIT);
            }
        }
    }

    public String getSessionFactoryJndiName() {
        return this.sessionFactoryJndiName;
    }

    public void setSessionFactoryJndiName(String sessionFactoryName) {
        this.sessionFactoryJndiName = sessionFactoryName;
    }

    public void setSessionFactory(Expressions.ValueBinding<SessionFactory> sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Expressions.ValueBinding<SessionFactory> getSessionFactory() {
        return this.sessionFactory;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public String toString() {
        return "ManagedHibernateSession(" + this.sessionFactoryJndiName + ")";
    }
}

