/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.exceptions;

import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.core.Pages;
import org.jboss.seam.core.RedirectException;
import org.jboss.seam.exceptions.ExceptionHandler;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

public abstract class RedirectHandler
extends ExceptionHandler {
    private static final LogProvider log = Logging.getLogProvider(RedirectHandler.class);

    protected abstract String getViewId(Exception var1);

    protected abstract String getMessage(Exception var1);

    protected abstract boolean isEnd(Exception var1);

    public void handle(Exception e) throws Exception {
        String viewId = this.getViewId(e);
        if (viewId == null) {
            String servletPath = ((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).getServletPath();
            viewId = servletPath.substring(0, servletPath.lastIndexOf(46)) + Pages.getSuffix();
        }
        RedirectHandler.addFacesMessage(RedirectHandler.getDisplayMessage(e, this.getMessage(e)));
        if (Contexts.isConversationContextActive() && this.isEnd(e)) {
            Conversation.instance().end();
        }
        try {
            this.redirect(viewId, null);
        }
        catch (RedirectException re) {
            log.debug("could not redirect", re);
        }
    }

    public String toString() {
        return "RedirectHandler";
    }
}

