/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.intercept;

import java.io.Serializable;
import java.util.List;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptorType;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.intercept.EE5SeamInvocationContext;
import org.jboss.seam.intercept.EventType;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.intercept.SeamInvocationContext;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.EJB;

public class RootInterceptor
implements Serializable {
    private static final long serialVersionUID = 8041533870186694663L;
    private static final LogProvider log = Logging.getLogProvider(RootInterceptor.class);
    private final InterceptorType type;
    private boolean isSeamComponent;
    private String componentName;
    private List<Object> userInterceptors;
    private transient Component component;

    protected RootInterceptor(InterceptorType type) {
        this.type = type;
    }

    protected void init(Component component) {
        this.isSeamComponent = true;
        this.componentName = component.getName();
        this.userInterceptors = component.createUserInterceptors(this.type);
        this.component = component;
    }

    protected void initNonSeamComponent() {
        this.isSeamComponent = false;
    }

    protected void postConstruct(Object bean) {
        if (this.isSeamComponent) {
            try {
                this.getComponent().initialize(bean);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("exception initializing EJB component", e);
            }
        }
    }

    protected void invokeAndHandle(InvocationContext invocation, EventType invocationType) {
        try {
            this.invoke(invocation, invocationType);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("exception in EJB lifecycle callback", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invoke(InvocationContext invocation, EventType invocationType) throws Exception {
        if (!this.isSeamComponent) {
            return invocation.proceed();
        }
        if (Contexts.isEventContextActive() || Contexts.isApplicationContextActive()) {
            return this.invokeInContexts(invocation, invocationType);
        }
        Lifecycle.beginCall();
        try {
            Object object = this.invokeInContexts(invocation, invocationType);
            return object;
        }
        finally {
            Lifecycle.endCall();
        }
    }

    private Object invokeInContexts(InvocationContext invocation, EventType eventType) throws Exception {
        if (this.isProcessInterceptors()) {
            if (log.isTraceEnabled()) {
                log.trace("intercepted: " + this.getInterceptionMessage(invocation, eventType));
            }
            return this.createSeamInvocationContext(invocation, eventType);
        }
        if (log.isTraceEnabled()) {
            log.trace("not intercepted: " + this.getInterceptionMessage(invocation, eventType));
        }
        return invocation.proceed();
    }

    private Object createSeamInvocationContext(InvocationContext invocation, EventType eventType) throws Exception {
        if (EJB.INVOCATION_CONTEXT_AVAILABLE) {
            return new EE5SeamInvocationContext(invocation, eventType, this.userInterceptors, this.getComponent().getInterceptors(this.type)).proceed();
        }
        return new SeamInvocationContext(invocation, eventType, this.userInterceptors, this.getComponent().getInterceptors(this.type)).proceed();
    }

    private String getInterceptionMessage(InvocationContext invocation, EventType eventType) {
        return this.getComponent().getName() + '.' + (eventType == EventType.AROUND_INVOKE ? invocation.getMethod().getName() : eventType);
    }

    private boolean isProcessInterceptors() {
        return this.isSeamComponent && this.getComponent().getInterceptionType().isActive();
    }

    protected Component getComponent() {
        if (this.isSeamComponent && this.component == null) {
            this.component = Seam.componentForName(this.componentName);
        }
        return this.component;
    }

    protected String getComponentName() {
        return this.componentName;
    }
}

