/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.interceptors;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.jboss.seam.ComponentType;
import org.jboss.seam.annotations.AroundInvoke;
import org.jboss.seam.annotations.Interceptor;
import org.jboss.seam.annotations.Rollback;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.interceptors.AbstractInterceptor;
import org.jboss.seam.interceptors.OutcomeInterceptor;
import org.jboss.seam.util.EJB;
import org.jboss.seam.util.Transactions;

@Interceptor(stateless=true, around={OutcomeInterceptor.class})
public class RollbackInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 5551801508325093417L;

    @AroundInvoke
    public Object rollbackIfNecessary(InvocationContext invocation) throws Exception {
        try {
            Object result = invocation.proceed();
            if (this.isRollbackRequired(invocation.getMethod(), result)) {
                Transactions.setTransactionRollbackOnly();
            }
            return result;
        }
        catch (Exception e) {
            if (this.getComponent().getType() == ComponentType.JAVA_BEAN && this.isRollbackRequired(e)) {
                try {
                    Transactions.setTransactionRollbackOnly();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    private boolean isRollbackRequired(Method method, Object result) {
        if (!method.isAnnotationPresent(Rollback.class)) {
            return false;
        }
        String[] outcomes = method.getAnnotation(Rollback.class).ifOutcome();
        List<String> outcomeList = Arrays.asList(outcomes);
        return outcomes.length == 0 || result == null && outcomeList.contains("org.jboss.seam.outcome.null") || outcomeList.contains(result);
    }

    private boolean isRollbackRequired(Exception e) {
        Class<?> clazz = e.getClass();
        return e instanceof RuntimeException && !clazz.isAnnotationPresent(EJB.APPLICATION_EXCEPTION) || clazz.isAnnotationPresent(EJB.APPLICATION_EXCEPTION) && EJB.rollback(clazz.getAnnotation(EJB.APPLICATION_EXCEPTION));
    }
}

