/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.interceptors;

import java.lang.reflect.Method;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.AroundInvoke;
import org.jboss.seam.annotations.Interceptor;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.interceptors.AbstractInterceptor;
import org.jboss.seam.interceptors.BijectionInterceptor;
import org.jboss.seam.interceptors.ValidationInterceptor;
import org.jboss.seam.security.Identity;

@Interceptor(stateless=true, around={ValidationInterceptor.class}, within={BijectionInterceptor.class})
public class SecurityInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -6567750187000766925L;

    @AroundInvoke
    public Object checkSecurity(InvocationContext invocation) throws Exception {
        Restrict r = null;
        Method method = invocation.getMethod();
        if (method.isAnnotationPresent(Restrict.class)) {
            r = method.getAnnotation(Restrict.class);
        } else if (method.getDeclaringClass().isAnnotationPresent(Restrict.class)) {
            r = method.getDeclaringClass().getAnnotation(Restrict.class);
        }
        if (r != null) {
            String expr = r.value() != null && !"".equals(r.value()) ? r.value() : this.createDefaultExpr(method);
            Identity.instance().checkRestriction(expr);
        }
        return invocation.proceed();
    }

    private String createDefaultExpr(Method method) {
        String name = Seam.getComponentName(method.getDeclaringClass());
        if (name == null) {
            throw new IllegalArgumentException(String.format("Method %s is not a component method", method));
        }
        return String.format("#{s:hasPermission('%s','%s', null)}", name, method.getName());
    }
}

