/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.log;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jboss.seam.log.LogImpl;
import org.jboss.seam.log.LogProvider;

public final class Log4JProvider
implements LogProvider {
    private final Logger logger;
    private static final String FQCN = LogImpl.class.getName();

    Log4JProvider(String category) {
        this.logger = Logger.getLogger((String)category);
    }

    public void debug(Object object) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, object, null);
    }

    public void debug(Object object, Throwable t) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, object, t);
    }

    public void error(Object object) {
        this.logger.log(FQCN, (Priority)Level.ERROR, object, null);
    }

    public void error(Object object, Throwable t) {
        this.logger.log(FQCN, (Priority)Level.ERROR, object, t);
    }

    public void fatal(Object object) {
        this.logger.log(FQCN, (Priority)Level.FATAL, object, null);
    }

    public void fatal(Object object, Throwable t) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, object, t);
    }

    public void info(Object object) {
        this.logger.log(FQCN, (Priority)Level.INFO, object, null);
    }

    public void info(Object object, Throwable t) {
        this.logger.log(FQCN, (Priority)Level.INFO, object, t);
    }

    public boolean isDebugEnabled() {
        return this.logger.isEnabledFor((Priority)Level.DEBUG);
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.logger.isEnabledFor((Priority)Level.FATAL);
    }

    public boolean isInfoEnabled() {
        return this.logger.isEnabledFor((Priority)Level.INFO);
    }

    public boolean isTraceEnabled() {
        return this.logger.isEnabledFor((Priority)Level.DEBUG);
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    public void trace(Object object) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, object, null);
    }

    public void trace(Object object, Throwable t) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, object, t);
    }

    public void warn(Object object) {
        this.logger.log(FQCN, (Priority)Level.WARN, object, null);
    }

    public void warn(Object object, Throwable t) {
        this.logger.log(FQCN, (Priority)Level.WARN, object, t);
    }
}

