/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.log;

import org.jboss.seam.log.JDKProvider;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Log4JProvider;
import org.jboss.seam.log.LogImpl;
import org.jboss.seam.log.LogProvider;

public class Logging {
    private static final boolean isLog4JAvailable;

    public static Log getLog(String category) {
        return new LogImpl(category);
    }

    public static Log getLog(Class clazz) {
        return new LogImpl(clazz.getName());
    }

    public static LogProvider getLogProvider(String category) {
        return isLog4JAvailable ? new Log4JProvider(category) : new JDKProvider(category);
    }

    public static LogProvider getLogProvider(Class clazz) {
        return Logging.getLogProvider(clazz.getName());
    }

    static {
        boolean available;
        try {
            Class.forName("org.apache.log4j.Logger");
            available = true;
        }
        catch (ClassNotFoundException cnfe) {
            available = false;
        }
        isLog4JAvailable = available;
    }
}

