/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mock;

import java.lang.reflect.Field;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.transaction.UserTransaction;
import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidValue;
import org.jboss.seam.Component;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.Pageflow;
import org.jboss.seam.core.Validators;
import org.jboss.seam.init.Initialization;
import org.jboss.seam.jsf.AbstractSeamPhaseListener;
import org.jboss.seam.jsf.SeamApplication11;
import org.jboss.seam.jsf.SeamNavigationHandler;
import org.jboss.seam.jsf.SeamPhaseListener;
import org.jboss.seam.jsf.SeamStateManager;
import org.jboss.seam.mock.MockApplication;
import org.jboss.seam.mock.MockExternalContext;
import org.jboss.seam.mock.MockFacesContext;
import org.jboss.seam.mock.MockHttpServletRequest;
import org.jboss.seam.mock.MockHttpSession;
import org.jboss.seam.mock.MockLifecycle;
import org.jboss.seam.mock.MockServletContext;
import org.jboss.seam.servlet.ServletSessionImpl;
import org.jboss.seam.util.Naming;
import org.jboss.seam.util.Transactions;
import org.testng.annotations.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamTest {
    private MockExternalContext externalContext;
    private MockServletContext servletContext;
    private MockApplication application;
    private AbstractSeamPhaseListener phases;
    private MockHttpSession session;
    private Map<String, Map> conversationViewRootAttributes;
    private Map<String, Object> pageParameters = new HashMap<String, Object>();

    protected void setParameter(String name, String value) {
        this.getParameters().put(name, new String[]{value});
    }

    protected void setPageParameter(String name, Object value) {
        this.pageParameters.put(name, value);
    }

    protected Map<String, String[]> getParameters() {
        return ((MockHttpServletRequest)this.externalContext.getRequest()).getParameters();
    }

    protected Map<String, String[]> getHeaders() {
        return ((MockHttpServletRequest)this.externalContext.getRequest()).getHeaders();
    }

    protected HttpSession getSession() {
        return (HttpSession)this.externalContext.getSession(true);
    }

    protected boolean isSessionInvalid() {
        return ((MockHttpSession)this.getSession()).isInvalid();
    }

    protected Object getInstance(Class clazz) {
        return Component.getInstance(clazz);
    }

    protected Object getInstance(String name) {
        return Component.getInstance(name);
    }

    protected boolean isLongRunningConversation() {
        return Manager.instance().isLongRunningConversation();
    }

    public Object lookup(String name) {
        return Contexts.lookupInStatefulContexts(name);
    }

    @Configuration(beforeTestMethod=true)
    public void begin() {
        this.session = new MockHttpSession(this.servletContext);
    }

    @Configuration(afterTestMethod=true)
    public void end() {
        if (Contexts.isEventContextActive()) {
            Lifecycle.endRequest(this.externalContext);
        }
        Lifecycle.endSession(this.servletContext, new ServletSessionImpl(this.session));
        this.session = null;
    }

    protected AbstractSeamPhaseListener createPhaseListener() {
        return new SeamPhaseListener();
    }

    @Configuration(beforeTestClass=true)
    public void init() throws Exception {
        this.application = new MockApplication();
        this.application.setStateManager(new SeamStateManager(this.application.getStateManager()));
        this.application.setNavigationHandler(new SeamNavigationHandler(this.application.getNavigationHandler()));
        this.phases = this.createPhaseListener();
        this.servletContext = new MockServletContext();
        this.initServletContext(this.servletContext.getInitParameters());
        Lifecycle.setServletContext(this.servletContext);
        new Initialization(this.servletContext).init();
        this.conversationViewRootAttributes = new HashMap<String, Map>();
    }

    @Configuration(afterTestClass=true)
    public void cleanup() throws Exception {
        Lifecycle.endApplication(this.servletContext);
        this.externalContext = null;
        this.conversationViewRootAttributes = null;
    }

    public void initServletContext(Map initParams) {
    }

    protected InitialContext getInitialContext() throws NamingException {
        return Naming.getInitialContext();
    }

    protected UserTransaction getUserTransaction() throws NamingException {
        return Transactions.getUserTransaction();
    }

    protected Object getField(Object object, String fieldName) {
        try {
            Field declaredField = object.getClass().getDeclaredField(fieldName);
            if (!declaredField.isAccessible()) {
                declaredField.setAccessible(true);
            }
            return declaredField.get(object);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not get field value: " + fieldName, e);
        }
    }

    protected void setField(Object object, String fieldName, Object value) {
        try {
            Field declaredField = object.getClass().getDeclaredField(fieldName);
            if (!declaredField.isAccessible()) {
                declaredField.setAccessible(true);
            }
            declaredField.set(object, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not set field value: " + fieldName, e);
        }
    }

    public class FacesRequest
    extends Request {
        public FacesRequest() {
        }

        public FacesRequest(String viewId) {
            this.setViewId(viewId);
        }

        public FacesRequest(String viewId, String conversationId) {
            super(conversationId);
            this.setViewId(viewId);
        }

        protected final boolean isGetRequest() {
            return false;
        }
    }

    public class NonFacesRequest
    extends Request {
        public NonFacesRequest() {
        }

        public NonFacesRequest(String viewId) {
            this.setViewId(viewId);
        }

        public NonFacesRequest(String viewId, String conversationId) {
            super(conversationId);
            this.setViewId(viewId);
        }

        protected final boolean isGetRequest() {
            return true;
        }

        protected final void applyRequestValues() throws Exception {
            throw new UnsupportedOperationException();
        }

        protected final void processValidations() throws Exception {
            throw new UnsupportedOperationException();
        }

        protected final void updateModelValues() throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class Request {
        private String conversationId;
        private String outcome;
        private boolean validationFailed;
        private MockFacesContext facesContext;
        private String viewId;
        private boolean renderResponseBegun;
        private boolean renderResponseComplete;
        private boolean invokeApplicationBegun;
        private boolean invokeApplicationComplete;
        private Application application;

        public String getPrincipalName() {
            return "gavin";
        }

        public Set<String> getPrincipalRoles() {
            return new AbstractSet<String>(){

                @Override
                public boolean contains(Object o) {
                    return true;
                }

                @Override
                public Iterator<String> iterator() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int size() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        protected Request() {
        }

        protected Request(String conversationId) {
            this.conversationId = conversationId;
        }

        protected boolean isGetRequest() {
            return false;
        }

        protected String getViewId() {
            return this.viewId;
        }

        protected void setViewId(String viewId) {
            this.viewId = viewId;
        }

        protected void applyRequestValues() throws Exception {
        }

        protected void processValidations() throws Exception {
        }

        protected void updateModelValues() throws Exception {
        }

        protected void invokeApplication() throws Exception {
        }

        protected void setOutcome(String outcome) {
            this.outcome = outcome;
        }

        protected String getInvokeApplicationOutcome() {
            return this.outcome;
        }

        protected void renderResponse() throws Exception {
        }

        protected void setup() {
        }

        protected void afterRequest() {
        }

        protected void beforeRequest() {
            this.setup();
        }

        protected String getRenderedViewId() {
            if (Init.instance().isJbpmInstalled() && Pageflow.instance().isInProcess()) {
                return Pageflow.instance().getPageViewId();
            }
            return this.getFacesContext().getViewRoot().getViewId();
        }

        protected void validate(Class modelClass, String property, Object value) {
            ClassValidator validator = Validators.instance().getValidator(modelClass, null);
            InvalidValue[] ivs = validator.getPotentialInvalidValues(property, value);
            if (ivs.length > 0) {
                this.validationFailed = true;
                FacesMessage message = FacesMessages.createFacesMessage(FacesMessage.SEVERITY_WARN, ivs[0].getMessage(), new Object[0]);
                FacesContext.getCurrentInstance().addMessage(property, message);
                FacesContext.getCurrentInstance().renderResponse();
            }
        }

        protected boolean isValidationFailure() {
            return this.validationFailed;
        }

        protected FacesContext getFacesContext() {
            return this.facesContext;
        }

        protected String getConversationId() {
            return this.conversationId;
        }

        protected Object getValue(String valueExpression) {
            return this.application.createValueBinding(valueExpression).getValue((FacesContext)this.facesContext);
        }

        protected void setValue(String valueExpression, Object value) {
            this.application.createValueBinding(valueExpression).setValue((FacesContext)this.facesContext, value);
        }

        protected boolean validateValue(String valueExpression, Object value) {
            InvalidValue[] ivs = Validators.instance().validate(this.facesContext, valueExpression, value);
            if (ivs.length > 0) {
                this.validationFailed = true;
                this.facesContext.addMessage(null, FacesMessages.createFacesMessage(FacesMessage.SEVERITY_WARN, ivs[0].getMessage(), new Object[0]));
                return false;
            }
            return true;
        }

        protected Object invokeMethod(String methodExpression) {
            return this.application.createMethodBinding(methodExpression, null).invoke((FacesContext)this.facesContext, null);
        }

        public String run() throws Exception {
            MockHttpServletRequest request = new MockHttpServletRequest(SeamTest.this.session, this.getPrincipalName(), this.getPrincipalRoles());
            SeamTest.this.externalContext = new MockExternalContext((ServletContext)SeamTest.this.servletContext, request);
            this.application = new SeamApplication11(SeamTest.this.application);
            this.facesContext = new MockFacesContext(SeamTest.this.externalContext, this.application);
            this.facesContext.setCurrent();
            this.beforeRequest();
            SeamTest.this.phases.beforePhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.RESTORE_VIEW, MockLifecycle.INSTANCE));
            UIViewRoot viewRoot = this.facesContext.getApplication().getViewHandler().createView((FacesContext)this.facesContext, this.getViewId());
            this.facesContext.setViewRoot(viewRoot);
            Map restoredViewRootAttributes = this.facesContext.getViewRoot().getAttributes();
            if (this.conversationId != null) {
                if (this.isGetRequest()) {
                    SeamTest.this.setParameter(Manager.instance().getConversationIdParameter(), this.conversationId);
                } else if (SeamTest.this.conversationViewRootAttributes.containsKey(this.conversationId)) {
                    Map state = (Map)SeamTest.this.conversationViewRootAttributes.get(this.conversationId);
                    restoredViewRootAttributes.putAll(state);
                }
            }
            if (!this.isGetRequest()) {
                restoredViewRootAttributes.putAll(SeamTest.this.pageParameters);
            }
            this.updateConversationId();
            SeamTest.this.phases.afterPhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.RESTORE_VIEW, MockLifecycle.INSTANCE));
            if (!this.isGetRequest() && !this.skipToRender()) {
                SeamTest.this.phases.beforePhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.APPLY_REQUEST_VALUES, MockLifecycle.INSTANCE));
                this.applyRequestValues();
                this.updateConversationId();
                SeamTest.this.phases.afterPhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.APPLY_REQUEST_VALUES, MockLifecycle.INSTANCE));
                if (!this.skipToRender()) {
                    SeamTest.this.phases.beforePhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.PROCESS_VALIDATIONS, MockLifecycle.INSTANCE));
                    this.processValidations();
                    this.updateConversationId();
                    SeamTest.this.phases.afterPhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.PROCESS_VALIDATIONS, MockLifecycle.INSTANCE));
                    if (!this.skipToRender()) {
                        SeamTest.this.phases.beforePhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.UPDATE_MODEL_VALUES, MockLifecycle.INSTANCE));
                        this.updateModelValues();
                        this.updateConversationId();
                        SeamTest.this.phases.afterPhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.UPDATE_MODEL_VALUES, MockLifecycle.INSTANCE));
                        if (!this.skipToRender()) {
                            SeamTest.this.phases.beforePhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.INVOKE_APPLICATION, MockLifecycle.INSTANCE));
                            this.invokeApplicationBegun = true;
                            this.invokeApplication();
                            this.invokeApplicationComplete = true;
                            String outcome = this.getInvokeApplicationOutcome();
                            this.facesContext.getApplication().getNavigationHandler().handleNavigation((FacesContext)this.facesContext, null, outcome);
                            this.viewId = this.getRenderedViewId();
                            this.updateConversationId();
                            SeamTest.this.phases.afterPhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.INVOKE_APPLICATION, MockLifecycle.INSTANCE));
                        }
                    }
                }
            }
            if (!this.skipRender()) {
                SeamTest.this.phases.beforePhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.RENDER_RESPONSE, MockLifecycle.INSTANCE));
                this.renderResponseBegun = true;
                this.renderResponse();
                this.renderResponseComplete = true;
                this.facesContext.getApplication().getStateManager().saveSerializedView((FacesContext)this.facesContext);
                this.updateConversationId();
                SeamTest.this.phases.afterPhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.RENDER_RESPONSE, MockLifecycle.INSTANCE));
                Map renderedViewRootAttributes = this.facesContext.getViewRoot().getAttributes();
                if (renderedViewRootAttributes != null) {
                    HashMap conversationState = new HashMap();
                    conversationState.putAll(renderedViewRootAttributes);
                    SeamTest.this.conversationViewRootAttributes.put(this.conversationId, conversationState);
                }
            }
            this.afterRequest();
            return this.conversationId;
        }

        private void updateConversationId() {
            this.conversationId = Manager.instance().getCurrentConversationId();
        }

        private boolean skipRender() {
            return FacesContext.getCurrentInstance().getResponseComplete();
        }

        private boolean skipToRender() {
            return FacesContext.getCurrentInstance().getRenderResponse() || FacesContext.getCurrentInstance().getResponseComplete();
        }

        protected boolean isInvokeApplicationBegun() {
            return this.invokeApplicationBegun;
        }

        protected boolean isInvokeApplicationComplete() {
            return this.invokeApplicationComplete;
        }

        protected boolean isRenderResponseBegun() {
            return this.renderResponseBegun;
        }

        protected boolean isRenderResponseComplete() {
            return this.renderResponseComplete;
        }
    }

    public abstract class Script
    extends Request {
        public Script() {
        }

        public Script(String conversationId) {
            super(conversationId);
        }
    }
}

